#ifndef _ADS1259_ARDUINO_H    /* Guard against multiple inclusion */
#define _ADS1259_ARDUINO_H

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdlib.h>

/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

// commands
#define WAKEUP_ADS1259    0x02
#define SLEEP_ADS1259     0x04
#define RESET_ADS1259     0x06
#define START_ADS1259     0x08
#define STOP_ADS1259      0x0A
#define RDATAC_ADS1259    0x10
#define SDATAC_ADS1259    0x11
#define RDATA_ADS1259     0x12
#define RREG_ADS1259      0x20
#define WREG_ADS1259      0x40
#define OFSCAL_ADS1259    0x18
#define GANCAL_ADS1259    0x19
#define WREG_ADS1259      0x40

// registers
#define CONFIG0_ADS1259   0x00
#define CONFIG1_ADS1259   0x01
#define CONFIG2_ADS1259   0x02
#define OFC0_ADS1259      0x03
#define OFC1_ADS1259      0x04
#define OFC2_ADS1259      0x05
#define FSC0_ADS1259      0x06
#define FSC1_ADS1259      0x07
#define FSC2_ADS1259      0x08

// delay bits DELAY[2:0]
#define DELAY_0           0
#define DELAY_64          1
#define DELAY_128         2
#define DELAY_256         3
#define DELAY_512         4
#define DELAY_1024        5
#define DELAY_2048        6
#define DELAY_4096        7

#define TIMEOUT           1000

//FSC регистр
typedef union{
    struct{
        uint32_t
        FSC0:8,
        FSC1:8,
        FSC2:8,
        :8;
    };
    struct{
        uint32_t
        FSC:24,
        :8;
    };
}__ADS1259_FSC_t;
extern __ADS1259_FSC_t ADS1259_FSCbits;

//OFC регистр
typedef union{
    struct{
        uint32_t
        OFC0:8,
        OFC1:8,
        OFC2:8,
        :8;
    };
    struct{
        uint32_t
        OFC:24,
        :8;
    };
}__ADS1259_OFC_t;
extern __ADS1259_OFC_t ADS1259_OFCbits;



//unsigned char ads1259_RegistersContent[9]; //переменная для хранения содержимого прочитанных регистров
    
    
    void ads1259_resetDevice ( unsigned char ch );
    void ads1259_powerDownDevice ( unsigned char adr );
    void ads1259_powerUpDevice ( unsigned char adr );
    void ads1259_conversionON ( unsigned char ch );
    void ads1259_conversionOFF ( unsigned char ch );
    char ads1259_readyDevice ( unsigned char ch );
    unsigned char ads1259_sendCommandDevice ( unsigned char command );
    void ads1259_setCsAndReset ( void );
    unsigned long ads1259_readRegisterDevice ( unsigned char reg, unsigned char num_reg, unsigned char ch );
    unsigned char ads1259_readOneRegisterDevice ( unsigned char reg );
    void ads1259_writeOneRegisterDevice ( unsigned char reg, unsigned char data );
    void ads1259_runReadDataContinuedModeDevice ( unsigned char ch );
    uint32_t ads1259_readDataDevice ( unsigned char ch );
    

    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _EXAMPLE_FILE_NAME_H */

/* *****************************************************************************
 End of File
 */
