#include "PerifConfig.h"
#include "PGA280.h"
#include "ADS1259.h"
#include "PGA280ADS1259.h"
#include "main.h"
#include "ad5422_arduino.h"
#include "lm35.h"
#include "LT1446.h"

#define PID_SAMPLE_TIME 0.25    //Период ПИД
#define Kp (E_PCOEFF)   //Получение коэффициентов ПИД
#define Ki (E_PCOEFF / E_ICOEFF * PID_SAMPLE_TIME)
#define Kd (E_PCOEFF * E_DCOEFF / PID_SAMPLE_TIME)

#define E_PCOEFF    0.11F    //Пропорциональный коэффициент ПИД регулятора (Из EEPROM)
#define E_ICOEFF    3000.0F //Постоянная времени интегрирования ПИД регулятора в секундах (Из EEPROM) (был 3000)
#define E_DCOEFF    0.1F
#define TEMP 35


/*Таймер для вызова функции каждые 40 мс*/
Ticker lm_temp;
Ticker adctask;
Ticker PID1;
/*Конец*/
InterruptIn button(USER_BUTTON);

volatile float Error = 0, dError = 0, last_Error = 0;    //Ошибка и предыдущее значение для ПИД
volatile float Integral = 0.0;    //Интегральная составляющая ПИД-регулятора
volatile uint8_t temp=0;
char mbflag;
unsigned char pga280gain;
char UComandFlag;
volatile unsigned char UComand;
volatile long tempdata=0;
char ch=0;                          //адрес на плате ТЭД-2 = 6
float x=0;
float k;
unsigned char str[];



//функция чтения АДС для выполнения в задаче
void readADC()
{
    tempdata=ads1259_readData(5);       //функция может зависать (надо избавиться от бесконечного цикла)          
    x=NormADC(tempdata);
    UART.printf("%08f\r\n",x);
}

void readtemp()
{    
    float t;
    /*Обработка ошибки*/
    LM35_start(0.25);
    if (LM35_0.ready) //если данные готовы то считать и сбросить флаг (способ многозадачности)
    {
        LM35_0.ready=0;
        t=LM35_0.temp;    
        Error=temp-t;  
        Integral += Error;
        dError = Error - last_Error;
        last_Error = Error;    
        //временно записать в калиброванное значение (нельзя так делать)
        LT1446_0.dacA.Code=(uint16_t)(PID() * 4095);
        LT1446_Write(&LT1446_0);
        UART.printf("Power %04d temp %0.1f\r\n",LT1446_0.dacA.Code,t);
    }
    
}
void printtemp()
{
    if (LM35_0.ready) //если данные готовы то считать и сбросить флаг (способ многозадачности)
    {
    UART.printf("TempCol %0.1f\r\n",LM35_0.temp);
    LM35_0.ready=0;
    }
    
    }

float inline NormADC(long data)
{
    x=data*2.5/0x800000;
    //x=x*8/(1<<pga280gain);
    return x;
}

void ComandCheck()
{    
    if(UART.getc()=='/')              
        {
        UART_gets(16); //моя функция на время
        UART.printf("%c\r\n",str[0]);
        switch (str[0]){
             case 'k':{
                 PID1.detach();
                 temp=(str[1]-'0')*10+(str[2]-'0');                 
                 UART.printf("temp= %d\r\n",temp);
                 break;}
             case 't':{
                 //снять показания термодатчика
                 LM35_start(0.25);
                 lm_temp.attach(&printtemp,0.25);
                 break;}
             case 'p':{                
                pga280gain=str[1]; //присваиваем числовое значение команды взятое из символа цифры
                pga280gain-=0x30;
                ch=5;
                pga280_setGAIN(pga280gain,ch);
                ch=0;               
                break;}            
            case 'g': {               
                //запустить задачу чтения АЦП каждые 40 мс (25 герц)
                adctask.attach(&readADC,0.04);               
                break;}
            case's':    {//остановить постоянное отображение
                adctask.detach();
                lm_temp.detach();
                LM35_stop();              
                break;}
            case 'd':
                //MBFlagRegister.DAC=1;
                break;
            case 'e':{
                tempdata=pga280_readOneRegisterDevice(PGA280_ERROR_ADR,5);//чтение ошибок                
                printf("ERRORS %X\n",tempdata);                               
                break;}            
            case 'r':{
                //перезагрука                           
                printf("System Reset\r\n");
                NVIC_SystemReset();
                break;}
            default:                
                //MBFlagRegister.TMLS=0; //починка зависания (не работает)
                break;            
        }
    }
}
 float PID ()
    {
    float P = Kp * Error;
    float I = Ki * Integral;
    float D = Kd * dError;
    float control = P + I + D;
    if (control > 1.0) return 1.0;
    if (control < 0.0) return 0.0;
    return control;
    }

void pressed()
{
    PID1.attach(&readtemp,0.25);
    UART.printf("PID is ON\r\n");
}

int main()
{    
    
    //Инициализация периферийных устройств
    SPI1_MasterInitMode(2);//работают режимы 1 и 2 
   //запустить задачу проверки команды по прерыванию УАРТ
    UART.attach(&ComandCheck,Serial::RxIrq);
    EN1=1;
          
    
    ch=5;
    pga280_setAdress(ch);    
    pga280_ads1259_init(ch); //инициализировать АЦП по адресу на плате ТЭД-2 = 5 (4)
    printf("\r\n");      
    tempdata=pga280_readOneRegisterDevice(PGA280_BUF_TIMEOUT_ADR,ch);
    printf("Timeout %X\n",tempdata);
    wait_ms(20);
    pga280_setGAIN(GAIN_1_PGA280,ch);
    pga280_setMUX(2,ch);
    pga280gain=3; //   gain=1 (0x03)
    tempdata=pga280_readOneRegisterDevice(PGA280_ERROR_ADR,ch);//чтение ошибок
    printf("Errors %X\n",tempdata);   
    /*Конец*/
    
    button.fall(&pressed);
    
        
    uint16_t q1=0;
    while(1)
    {     
      q1=4;
      while(q1--){
          SPI1_MasterInitMode(q1);
    Cs=0;   
    TED2.write(0x00);    
    TED2.write(0x00);
    TED2.write(0x00);    
    Cs=1;
    UART.printf("%d\r\n",q1);
    wait_ms(3000);          
          }
    }
}
 