/* mbed PCA9672 I2C I/O Expander Library
 * Copyright (c) 2013 viswesr
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "PCA9672.h"

PCA9672::PCA9672(PinName sda, PinName scl) : _i2c(sda, scl)
{
    // Software Reset
    _i2c.start();
    while(_i2c.write(0x00) !=1);
    while(_i2c.write(0x06) !=1);
    _i2c.stop();

    /* Software reset is not required. But, gives an 
       indication if the selected I2C bus frequency works */
}

void PCA9672::frequency(int hz)
{
    _i2c.frequency(hz);
}

void PCA9672::write(char value)
{
    _i2c.write(PCA9672_ADDR, &value, 1);
}

int PCA9672::read(void)
{
    _i2c.read(PCA9672_ADDR | 0x01);
}

PCA9672::~PCA9672()
{

}