/* mbed PCA9672 I2C I/O Expander Library
 * Copyright (c) 2013 viswesr
 *
 * MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef PCA9672_H
#define PCA9672_H
 
#include "mbed.h"
 
//  PCA9672 IIC slave address
#define  PCA9672_ADDR 0x46
 

//!Library for the PCA9672 I/O expander.
/*!
The PCA9672 is an I2C I/O expander. It has 8 I/O pins.
*/
class PCA9672
{
public:
  /*!
  Connect PCA9672 to I2C port pins sda and scl.
  */
  PCA9672(PinName sda, PinName scl);
  
  /*!
  Set the frequency of the I2C interface.
  */
  void frequency(int hz);

  /*!
  Write the value to the IO Expander (pins XP0-XP7 output)
  */
  void write(char value);
  
  /*!
  Read the value of the IO Expander (pins XP0-XP7 input)
  */
  int read(void);
    
  /*!
  Destroys instance.
  */ 
  ~PCA9672();
  
private:
  
  I2C _i2c;
 
};
 
#endif