/* IR remote for D3200 DSLR camera. Should work with other DSLR cameras that support ML-L3 remote. Implemented with mbed
   based on a nice documentation of ML-L3 protocol by Michele Bighignoli (http://www.bigmike.it/ircontrol/) */

#include "mbed.h"

/* P0_9 is connected to an IR LED and P1_14 to a button in Seeedstudio Arch.
   Change these pins as per your platform. */
#define LED_PIN     P0_9
#define BUTTON_PIN  P1_14

PwmOut IRled(LED_PIN);     /* Connect a suitable current limiting resistor.
                              For longer range, use a transistor for driving IR LED */

DigitalIn button(BUTTON_PIN);  /* Push button to enable shutter release */

void shutterrelease();

int main()
{
    button.mode(PullDown);
    IRled.period_us(26);                // set PWM period for Carrier Frequency of 38.4 KHz
    IRled.write(0);

    while(1) {
        if(button) {
            shutterrelease();
        }
    }

}

void shutterrelease()
{
    /* Shutter release command sequence */
    IRled.write(0.5);
    wait_us(2000);
    IRled.write(0);
    wait_us(27830);
    IRled.write(0.5);
    wait_us(400);
    IRled.write(0);
    wait_us(1580);
    IRled.write(0.5);
    wait_us(400);
    IRled.write(0);
    wait_us(3580);
    IRled.write(0.5);
    wait_us(400);
    IRled.write(0);
    wait_us(63200);  // Wait for 63.2ms and repeat the above sequence.
    IRled.write(0.5);
    wait_us(2000);
    IRled.write(0);
    wait_us(27830);
    IRled.write(0.5);
    wait_us(400);
    IRled.write(0);
    wait_us(1580);
    IRled.write(0.5);
    wait_us(400);
    IRled.write(0);
    wait_us(3580);
    IRled.write(0.5);
    wait_us(400);
    IRled.write(0);
}
