#include "mbed.h"
#include "SerialLCD.h"
 
SerialLCD lcd(P1_13, P1_14);  /* Grove Serial LCD is connected to UART Tx and Rx pins*/
 
AnalogIn thermistor(P0_11);   /* Thermistor output connected to P0_11 */
 
int main()
{
    char strBuffer[16];
    unsigned int a, beta = 3975;
    float temperature, resistance;
    
    lcd.begin();                 /* initialize Serial LCD communication. */ 
 
    while(1) {
        a = thermistor.read_u16(); /* Read analog value */
        
        /* Calculate the resistance of the thermistor from analog votage read. */
        resistance= (float) 10000.0 * ((65536.0 / a) - 1.0);
        
        /* Convert the resistance to temperature using Steinhart's Hart equation */
        temperature=(1/((log(resistance/5000.0)/beta) + (1.0/298.15)))-273.15; 
        
        sprintf(strBuffer, "Tmp %4.2f deg C", temperature); /* prepare a string buffer to print number */   
        lcd.setCursor(0, 0);  /* set cursor at 0th column and 0st row */
        lcd.print(strBuffer); /* print the string buffer */
      
        wait(0.5);
    }
}