#include "slave.h"
#include "HK.h"

extern SensorData Sensor;
I2CSlave slave(p28,p27);                       //configuring pins p27, p28 as I2Cslave
Serial screen (USBTX,USBRX);
void write_to_master(char send)                           //function to write data to master
        {
           int acknowledge; 
           int loopvariable4=1;
           while(loopvariable4)
           {
           acknowledge = slave.write(send);    //sending the byte to master
           if(acknowledge==1)
            {
              screen.printf(" acknowledge %d sent %x \n",acknowledge,send);
              loopvariable4=0;
            }
           } 
        }
        



void FUNC_I2C_SLAVE_MAIN(int slave_address,int iterations)
{
    wait(0.5);
    screen.printf("\nSlave entered\n");
    slave.address(slave_address);                           //assigning slave address
    int Switch_Variable;
    int ReadAddressed=1;
    int WriteGeneral=3;
    int loopvariable1=1;
    int loopvariable2=0;
    int loopvariable3=1;
//initialising dummy sensor data                         
    
    while(loopvariable1)
    { 
//to read data from master       
    if(slave.receive()==WriteGeneral)                   //checking if slave is addressed to write
    {
      Switch_Variable=slave.read();                   //receiving data
      screen.printf("switch variable=%d\n",Switch_Variable);
      slave.stop();                          //reset slave to default receiving state
      loopvariable1=0;
//to interpret and write data to master       
      switch(Switch_Variable)
      {
      
       case 1:    while(loopvariable3)
                  {
                     if(slave.receive()==ReadAddressed)             //check if slave is addressed to read 
                   {
                      while(loopvariable2<iterations)
                     {
                      if(loopvariable2%3==0)
                          {
                          screen.printf("\nvoltage%d\n",loopvariable2/3);
                          write_to_master(Sensor.Voltage[loopvariable2/3]);
                          }
                      else if(loopvariable2%3==1)
                          {   
                          screen.printf("\ncurrent%d\n",loopvariable2/3);
                          write_to_master(Sensor.Current[loopvariable2/3]);
                          }
                      else if(loopvariable2%3==2)
                          {   
                          screen.printf("\ntemp%d\n",loopvariable2/3);
                          write_to_master(Sensor.Temp[loopvariable2/3]);
                          }         
                      loopvariable2++;
                       }//while(loopvariable2<30)
                      slave.stop();    
                      loopvariable3=0;  
                    }//if(read addressed)
                    
                    }//while(loopvariable3)
                  
                  break;
         case 2 : screen.printf(" telecommand 2\n");
                  break;         
                 
        }//switch case ends
   }   
}
   screen.printf("done");
}
