#include "slave.h"
I2CSlave slave(p28,p27);                       //configuring pins p27, p28 as I2Cslave
Serial pc (USBTX,USBRX);
//SensorData Sensor;
struct SensorData                              //HK_data_structure
{
    char voltage[10];
    char current[10];
    char temp[10];
}Sensor;

int FUNC_I2C_SLAVE_MAIN(int iterations)
{
    
    wait(0.5);
    slave.address(0x20);                        //assigning slave address
    char Switch_Variable;
    int ReadAddressed=1;
    int WriteGeneral=3;
    bool loopvariable1=true;
    uint8_t loopvariable2=0;
    bool loopvariable3=true;
//---------------initialising dummy sensor data-----------------------------------------------------------                         
    Sensor.voltage[0]='a';Sensor.current[0]='1';Sensor.temp[0]='k';
    Sensor.voltage[1]='b';Sensor.current[1]='2';Sensor.temp[1]='l';
    Sensor.voltage[2]='c';Sensor.current[2]='3';Sensor.temp[2]='m';
    Sensor.voltage[3]='d';Sensor.current[3]='4';Sensor.temp[3]='n';
    Sensor.voltage[4]='e';Sensor.current[4]='5';Sensor.temp[4]='o';
    Sensor.voltage[5]='f';Sensor.current[5]='1';Sensor.temp[5]='p';
    Sensor.voltage[6]='g';Sensor.current[6]='2';Sensor.temp[6]='q';
    Sensor.voltage[7]='h';Sensor.current[7]='3';Sensor.temp[7]='r';
    while(loopvariable1)
    { 
//------------------------to read data from master---------------------------------------------------------       
    if(slave.receive()==WriteGeneral)                 //checking if slave is addressed to write
    {
      Switch_Variable=slave.read();                   //receiving data
      printf("switch variable=%d\n",Switch_Variable);
      slave.stop();                                   //reset slave to default receiving state
      loopvariable1=false;
//----------------------to interpret and write data to master----------------------------------------------       
      switch(Switch_Variable)
      {
      
       case '1':  while(loopvariable3)
                 {
                     if(slave.receive()==ReadAddressed)             //check if slave is addressed to read 
                   {
                      loopvariable3=false;
                      while(loopvariable2<8)                              //running loop for sending 30 sensors data
                       {
                          printf("\nvoltage%d\n",loopvariable2);
                          write_to_master(Sensor.voltage[loopvariable2]);   //calling function to send float data     
                             
                          printf("\ncurrent%d\n",loopvariable2);
                          write_to_master(Sensor.current[loopvariable2]);  //calling function to send float data 
                             
                          printf("\ntemp%d\n",loopvariable2);
                          write_to_master(Sensor.temp[loopvariable2]);    //calling function to send float data
                                   
                      loopvariable2++;      
                      }
                      
                    }
                                       
                  }  
                  break;
       case '2' : printf(" telecommand 2\n");
                  break;         
                 
        }
   }   
}
   slave.stop();
   printf("done");
}

//------------------function to write data to master---------------------------------------------------
void write_to_master(char send)                           
{
     bool acknowledge;
     bool loopvariable4=true; 
     while(loopvariable4)
      {
        acknowledge = (bool) slave.write(send);    //sending the byte to master
        if(acknowledge)                  //breaking loop if data is acknowledged
         {
            printf(" acknowledge %d sent %x \n",acknowledge,send);
            loopvariable4 = false;
         }
      } 
}