#include "mbed.h"
#include "rtos.h"
#include "HK.h"
#include "slave.h"
#include "beacon.h"
#include "ACS.h"
//watda?
Serial pc(USBTX, USBRX);



Timer t;
Timer t1;

Thread *ptr_t_hk_acq;
Thread *ptr_t_acs;
Thread *ptr_t_acs_write2flash;
Thread *ptr_t_bea;
Thread *ptr_t_bea_telecommand;
Thread *ptr_t_fault;


//----------------------------------------------HOUSE-KEEPING(HK)------------------------------------------------------------------------------------------
//void func_hk_mux()
//{
//    pc.printf("Something related to mux\n");
//}
//
//void func_hk_adc()
//{
//    pc.printf("Converting analog to digital\n");
//}
//
//void func_hk_write2flash()
//{
//    pc.printf("Writing the house keeping data to flash\n");
//}
//
//void func_hk_readram()
//{
//    pc.printf("Reading hk data from ram\n");
//}

//void func_hk_send2cdms()
//{
//    pc.printf("Send the data to sd card\n");
//}

void t_hk_send2cdms(void const *args)
{
    while(1)
    {
        t.start();
        Thread::signal_wait(0x4);
        printf("\nEntered t_hk_send2cdms\n");
        /*printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());*/
             
        FUNC_I2C_SLAVE_MAIN(24);
        printf("The time to execute send2cdms is %f\n",t.read());
        t.reset();
    }
}

void t_hk_acq(void const *args)
{
    Thread thread_2(t_hk_send2cdms);
    while(1)
    {
        Thread::signal_wait(0x2);
        
        printf("\nTHIS IS HK    %f\n",t1.read());
        t.start();
        
        FUNC_HK_MAIN();
        //thread_2.signal_set(0x4);
        FUNC_I2C_SLAVE_MAIN(24);
        /*printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());*/
        t.stop();
        printf("The time to execute hk_acq is %f seconds\n",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------

typedef struct {
    float mag_field;
    float omega;
    } sensor_data;
    
Mail <sensor_data, 16> q_acs;
    
void func_acs_readdata(sensor_data *ptr)
{
    pc.printf("Reading the data\n");
    ptr -> mag_field = 10;
    ptr -> omega = 3;
}

void func_acs_ctrlalgo()
{
    pc.printf("Executing control algo\n");
}

/*void func_acs_pwmgen()
{
    pc.printf("Generating PWM signal\n");
}*/

void func_acs_write2flash(sensor_data *ptr2)
{
    pc.printf("The magnetic field is %.2f T\n\r",ptr2->mag_field);
    pc.printf("The angular velocity is %.2f rad/s\n\r",ptr2->omega);
}

void t_acs(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("\nTHIS IS ACS   %f\n",t1.read());
        t.start();
        sensor_data *ptr = q_acs.alloc();
        func_acs_readdata(ptr);
        q_acs.put(ptr);
        func_acs_ctrlalgo();
        FUNC_ACS_GENPWM();
        
        /*printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());
        printf("The time to execute t_acs is %f seconds\n",t.read());*/
            //   Thread::wait(10000);
        t.reset();
    }
}

void t_acs_write2flash(void const *args)
{
    while(1)
    {
        //printf("Writing in the flash\n");
        osEvent evt = q_acs.get();
        if(evt.status == osEventMail)
        {
            sensor_data *ptr = (sensor_data*)evt.value.p;
            func_acs_write2flash(ptr);
            q_acs.free(ptr);
        }
        printf("Writing acsd data in the flash\n");
    }
}

//---------------------------------------------------BEACON--------------------------------------------------------------------------------------------

int beac_flag=0;

/*void func_bea_readbaeflash()
{
        pc.printf("Reading data from beacon flash\n");
        wait(0.01);
}

void func_bea_spiwrite()
{
    pc.printf("Writing through SPI\n");
    wait(0.01);
}
*/
void t_bea_telecommand(void const *args)
{
    char c = pc.getc();
    if(c=='a')
    {
        pc.printf("Telecommand detected\n");
        beac_flag=1;
    }
}

void t_bea(void const *args)
{
    
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("\nTHIS IS BEACON    %f\n",t1.read());
        t.start();
        /*printf("The state of hk_acq thread is %d\n",ptr_t_hk_acq->get_state());
        printf("The state of acs_main thread is %d\n",ptr_t_acs->get_state());
        printf("The state of acs_write2flash thread is %d\n",ptr_t_acs_write2flash->get_state());
        printf("The state of beacon thread is %d\n",ptr_t_bea->get_state());*/
        if(beac_flag==0)
        {
            //func_bea_readbaeflash();
            //func_bea_spiwrite();
            beacon_func();
            //Thread::wait(30000);
        }
        else
        {
            Thread::wait(600000);
            beac_flag = 0;
        }
        
        printf("The time to execute beacon thread is %f seconds\n",t.read());
        t.reset();
    }
}

//---------------------------------------------------------------------------------------------------------------------------------------------------
//TASK 4 : FAULT MANAGEMENT
//---------------------------------------------------------------------------------------------------------------------------------------------------
//Dummy fault rectifier functions

Mail<int,16> faults;

void FUNC_FAULT_FUNCT1()
{
    pc.printf("\nFault 1 detected... \n");
}

void FUNC_FAULT_FUNCT2()
{
    pc.printf("\nFault 2 detected...\n");
}

void T_FAULT(void const *args)
{
    while(1)
    {
        osEvent evt = faults.get();
        if(evt.status==osEventMail)
        {
            int *fault_id= (int *)evt.value.p;
            switch(*fault_id)
            {
                case 1: FUNC_FAULT_FUNCT1();
                        break;
                case 2: FUNC_FAULT_FUNCT2();
                        break;
            }
            faults.free(fault_id);
        }
    }
}

//------------------------------------------------------------------------------------------------------------------------------------------------
//SCHEDULER
//------------------------------------------------------------------------------------------------------------------------------------------------
uint16_t schedcount=1;
void t_sc(void const *args)
{
    
    printf("The value of i in scheduler is %d\n",schedcount);
    if(schedcount == 65532)                         //to reset the counter
    {
        schedcount = 0;
    }
    
    if(schedcount%1==0)
    {
        //ptr_t_acs -> signal_set(0x1);
    }
    if(schedcount%2==0)
    {
        ptr_t_hk_acq -> signal_set(0x2);
    }
    if(schedcount%3==0)
    {
        //ptr_t_bea -> signal_set(0x3);
    }
    schedcount++;
}
    
//---------------------------------------------------------------------------------------------------------------------------------------------

int main()
{
    t1.start();
    
    ptr_t_hk_acq = new Thread(t_hk_acq);
    ptr_t_acs = new Thread(t_acs);
    ptr_t_acs_write2flash = new Thread(t_acs_write2flash);
    ptr_t_bea = new Thread(t_bea);
    ptr_t_bea_telecommand = new Thread(t_bea_telecommand);
    ptr_t_fault = new Thread(T_FAULT);
    //ptr_t_sc = new Thread(t_sc);

    ptr_t_fault -> set_priority(osPriorityRealtime);
    ptr_t_acs->set_priority(osPriorityHigh);
    ptr_t_hk_acq->set_priority(osPriorityNormal);
    ptr_t_acs_write2flash->set_priority(osPriorityBelowNormal);
    ptr_t_bea->set_priority(osPriorityAboveNormal);
    ptr_t_bea_telecommand->set_priority(osPriorityIdle);
    //ptr_t_sc->set_priority(osPriorityAboveNormal);
    
    /*RtosTimer for individual thread-------------------------------------------------------------------------------------------
    RtosTimer t_hk_acq_timer(t_hk_acq, osTimerPeriodic);
    RtosTimer t_acs_timer(t_acs, osTimerPeriodic);    
    RtosTimer t_bea_timer(t_bea, osTimerPeriodic);
    
    t_hk_acq_timer.start(20000);
    t_acs_timer.start(10000);
    t_bea_timer.start(30000);
    ----------------------------------------------------------------------------------------------*/    
    pc.printf("\n T_FAULT priority is %d",ptr_t_fault->get_priority()); 
    pc.printf("\n T_ACS priority is %d",ptr_t_acs->get_priority());
    pc.printf("\n T_HK_ACQ priority is %d",ptr_t_hk_acq->get_priority());
    pc.printf("\n T_ACS_WRITE2FLASH priority is %d",ptr_t_acs_write2flash->get_priority());
    pc.printf("\n T_BEA priority is %d",ptr_t_bea->get_priority());  
    RtosTimer t_sc_timer(t_sc,osTimerPeriodic);
    t_sc_timer.start(10000);
    printf("\n%f\n",t1.read()); 
        
    while(1)
    {
        Thread::wait(10000);
        ;
    }
    
}