#include "mbed.h"

const int addr = 0x20;                     //slave address 
I2C master (D14,D15);                      //configure pins p27,p28 as I2C master
Serial pc (USBTX,USBRX);

int write_to_slave(char);
char* read_from_slave();

bool write_ack  = true; 
bool read_ack   = true;
char* data_send = new char;
char* data_rec  = new char;
bool write_loop = true;
bool read_loop  = true;


int main(){
    
    while(1)
    {
        printf("1 press backspace for master to start \n\r");
        if(pc.getc()==8){
            master.frequency(100000);
            data_rec = read_from_slave();
            printf("4 in main read %c from slave\n\r",*data_rec);
        }    
    }
}    
    
int write_to_slave(char send){
     
                printf("2 master clk freq setup and addressing slave\n\r");
                master.frequency(100000);                       //set clock frequency
                write_loop = true;
                while(write_ack){  
                    master.start();                                 //initiating the data transfer
                    printf("entered write loop \n\r");
            
                    write_ack = (bool) master.write(addr|0x00,&send,1,false);
                    if(!write_ack){
                        printf("3 master has written %c to slave\n\r",send);
                        write_loop=false;
                        
                    }
                }
                return(1);
}

char* read_from_slave(){
          read_ack = true;
          printf("2 master entered function to read\n\r");
          while(read_ack){
                master.start();                                 //initiating the data transfer
                read_ack = (bool) master.read(addr|0x1,data_rec,1,false);
                //printf("3 addressing slave\n\r");
          }  
          printf("4 master has read %c from slave\n\r",*data_rec);
          return(data_rec);
}