#include "mbed.h"
#include "rtos.h"
#include "master.h"

//#include "tmtc.h"
//#include "science.h"
//#include "hk.h"
 
#define intmax 11999

Thread* t_tmtc;
Thread* t_science_store_sd;
Thread* t_hk_store_sd;

void t_tmtc_main(void const *args);
void t_science_main(void const *args);
void t_hk_main(void const *args);
void scheduler(void const * args);

Timer timer_main;
int schedcount = 1;
Mutex critical;
 
int main() {
    Thread thread_tmtc(t_tmtc_main, NULL, osPriorityIdle);
    t_tmtc = &thread_tmtc;
    Thread thread_science(t_science_main, NULL, osPriorityLow);
    t_science_store_sd = &thread_science;
    Thread thread_hk(t_hk_main, NULL, osPriorityBelowNormal);
    t_hk_store_sd = &thread_hk;
        
    RtosTimer schedule(scheduler,osTimerPeriodic);
    timer_main.start();
    schedule.start(5000);
    Thread::wait(osWaitForever);
}

void scheduler(void const * args)
{
    if(schedcount == intmax+1)                              //the value is reset at this value so as to ensure smooth flow, 65532 and 0 are divisible by 3 and 2.
    {
        schedcount =0;
    }
         
    if(schedcount%4==0)
    {
        printf("\nHK signal at %f\n",timer_main.read());
        t_hk_store_sd->signal_set(0x01);
    }
    
    if(schedcount%3==0)
    {
        printf("\nScience signal at %f\n",timer_main.read());
        t_science_store_sd->signal_set(0x01);
    }
    
    if(schedcount==5)
    {
        printf("\nTMTC signalled");
        t_tmtc->signal_set(0x1);
    }
    
    schedcount++;
}

void t_science_main(void const *args) {
    while (true) {
        Thread::signal_wait(0x1);       
        critical.lock();
        printf("science data aquisition started\n");
        wait(3);
        printf("science data acquisition ended\n");
        t_hk_store_sd->signal_set(0x10);
        critical.unlock();
        wait(3);
        printf("Science data written to SD card\n");
    }
}

void t_hk_main(void const *args) {
    while (true) {
        Thread::signal_wait(0x1);
        critical.lock();
        printf("HK acquisition started\n");
        //FUNC_I2C_MASTER_MAIN(1,0x20,24 );
        wait(2);
        printf("HK acquisition ended\n");
        critical.unlock();
        wait(2);
        printf("HK data written to SD card");
    }
}

void t_tmtc_main(void const *args) {
    Thread::signal_wait(0x1);
    critical.lock();
    printf("tmtc started\n");
    wait(5);
    printf("tmtc ended\n");
    critical.unlock();
    wait(5);
    printf("tmtc executed\n");
}