#pragma once
#include "mbed.h"
//https://developer.mbed.org/users/4180_1/notebook/using-the-esp8266-with-the-mbed-lpc1768/
//modified to run on KL25Z using serial port at PTA2,PTA1 (tx,rx) and PTD4 as RST pin
#include "MMA8451Q.h"
#include "C12832.h"
#include "FreescaleIAP.h"

PinName const SDA = PTE25;
PinName const SCL = PTE24;

#define IP "api.thingspeak.com"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
char cDataBuffer[100];
double latitude, longitude;
double lat_ch,long_ch;
//int i = 0;


void Init();
void parse(char *cmd, int n);
void check();

Serial pc(USBTX,USBRX);
Serial gps(PTD3, PTD2);//tx,rx
Serial esp(PTC4,PTC3); // tx, rx
DigitalOut reset(PTD4);
DigitalOut alert(PTD5);
//C12832 lcd(D11, D13, D12, D7, D10);


Timer timer1;
//Timer time;

int  count,ended,timeout;
char buf='0';
char snd[255];

char ssid[32] = "praveena";     // enter WiFi router ssid inside the quotes
char pwd [32] = "12345678"; // enter WiFi router password inside the quotes
int t;
void record(void);
//void check(void);

void SendCMD(),getreply(),ESPconfig(),ESPsetbaudrate();
int main(void) {
    int flag=0;
    pc.baud(115200);
    esp.baud(115200);   // change this to the new ESP8266 baudrate if it is changed at any time.
    gps.baud(9600);
    int over = 1;
    char c;
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
     //lcd.cls();
      timer1.start();
      reset=0; //hardware reset for 8266
      // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();

    

    //ESPsetbaudrate();   //******************  include this routine to set a different ESP8266 baudrate  ******************

    ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************

   
   

    while (true) 
    { 
        over = 1;
         //lcd.locate(0,3);
        while(over){
         if(gps.readable())
        { 
            pc.printf("hi\n\r");
            if(gps.getc() == '$');           // wait a $
            {
                for(int i=0; i<sizeof(cDataBuffer); i++)
                {
                    c = gps.getc();
                    if( c == '\r' )
                    {
                        pc.printf("hi\n\r");
                        parse(cDataBuffer, i);
                        i = sizeof(cDataBuffer);
                        over = 0;
                    }
                    else
                    {
                        cDataBuffer[i] = c;
                    }                 
                }
            }
         }
         } 
         pc.printf("GPS: latitude: %.6f :: longitude: %.6f\n\r", latitude/100.0 , longitude/100.0);
        check();
        float z;

        z = (acc.getAccZ())*10;
        wait(0.1);
        //check();
        if(z<=8.0 || z>= 10.5)
        { flag++;
            if(flag == 1){
                 t= timer1.read();
                 }
                if( (timer1.read() - t) >= 2.5 && (timer1.read() - t) < 4.5 && flag>2){
                    //lcd.locate(0,15);
                    //int p=t;
                    pc.printf("bump detected at latitude: %.6f :: longitude: %.6f\n\r", latitude/100.0 , longitude/100.0);
                    lat_ch=latitude;
                    long_ch=longitude;
                    flag =0;
                    wait(5);
                    record();
                    //lcd.cls();
                }
            else if( (timer1.read() - t) >= 5.0 ){
                    flag =0;
                }
            }
            
           //lcd.locate(0,15); 
           pc.printf("good to go\n\r");
           //wait(0.5);
             
    }
}
void record()
{
    


    // continuosly get AP list and IP
        pc.printf("\n---------- Listing Acces Points ----------\r\n");
        
        
        strcpy(snd,"AT+CIPMODE=0\r\n");//Setting WiFi into MultiChannel mode
        SendCMD();
        getreply();
        pc.printf("       buf  = ##start %s                 ..##end\n",buf);
        wait(0.5);
        /*
        strcpy(snd,"AT+CIPMUX=1");//Setting WiFi into MultiChannel mode
        SendCMD();
        getreply();
        pc.printf("       buf  = ##start %s                 ..##end\n",buf);
        wait(0.5);
        */
        //pc.printf("%s\n\r",buf);
        strcpy(snd,"AT+CIPSTART=4,\"TCP\",\"api.thingspeak.com\",80\r\n");
        SendCMD();
        timeout=5;
        getreply();
        wait(1);
        strcpy(snd,"AT+CIPSEND=4,68\r\n");
        SendCMD();
        timeout=1;
        getreply();
        wait(1);
        sprintf(snd,"GET /update?key=DLTFSJQRE1WQTXF3&field1=%.6f&field2=%.6f\r\n",latitude/100.0,longitude/100.0); 
        SendCMD();
        timeout=1;
        getreply();
        wait(1);
        pc.printf("length = %d\n\r",strlen(snd));
        getreply();
        pc.printf("       buf  = ##start %s                 ..##end\n\r",buf);
        strcpy(snd,"AT+CIPCLOSE=4\r\n"); 
        SendCMD();
        timeout=1;
        getreply();
        wait(1);
        //wait(1);

}

// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}

//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{
    wait(5);
    strcpy(snd,"AT\r\n");
    SendCMD();
    
    getreply();
    wait(1);
    pc.printf("%s\n\r",buf);
    strcpy(snd,"AT\r\n");
    SendCMD();
    getreply();
    wait(1);
    pc.printf("%s\n\r",buf);
    strcpy(snd,"AT\r\n");
    SendCMD();
    timeout=1;
    getreply();
    wait(1);
    pc.printf("%s\n\r",buf);
    pc.printf("\f---------- Starting ESP Config ----------\r\n");

    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"AT+RST\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n",buf);

    wait(2);

    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"AT+GMR\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n",buf);

    wait(3);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "AT+CWMODE=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n",buf);

    wait(2);

    // set CIPMUX to 0=Single,1=Multi
    pc.printf("\n---------- Setting Connection Mode ----------\r\n");
    strcpy(snd, "AT+CIPMUX=1\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n",buf);

    wait(2);
/*
    pc.printf("\n---------- Listing Access Points ----------\r\n");
    strcpy(snd, "AT+CWLAP\r\n");
    SendCMD();
    timeout=15;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n",buf);

    wait(2);
*/
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "AT+CWJAP=\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\"\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n",buf);

    wait(5);
    

    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "AT+CIFSR\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n\r",buf);

    wait(1);

    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "AT+CIPSTATUS\r\n");
    SendCMD();
    timeout=2;
    getreply();
    pc.printf("       buf  = ##start %s                 ..##end\n\r",buf);
    /*

    pc.printf("\n\n\n  If you get a valid (non zero) IP, ESP8266 has been set up.\r\n");
    pc.printf("  Run this if you want to reconfig the ESP8266 at any time.\r\n");
    pc.printf("  It saves the SSID and password settings internally\r\n");
    wait(10);*/
}

void SendCMD()
{
    esp.printf("%s", snd);
}

void getreply()
{
    //memset(buf, '\0', sizeof(buf)); // this zeros the array
    timer1.stop();
    timer1.reset();
    timer1.start(); //  start a timer
    ended=0; 
    //count=0;
    while(!ended) {
        //pc.putc('c');
        while(esp.readable()) {
            buf= esp.getc();
            pc.putc(buf);
            //count++;
        }
       if(timer1.read() > timeout) {
            //pc.putc('$');
            ended = 1;
            //t.stop();
//            t.reset();
        }
    }
}

inline void parse(char *cmd, int n)
{
    
    char ns, ew, tf, status;
    int fq, nst, fix, date;                                     // fix quality, Number of satellites being tracked, 3D fix
    float timefix, speed, altitude;
    
    
    // Global Positioning System Fix Data
    if(strncmp(cmd,"$GPGGA", 6) == 0) 
    {
        sscanf(cmd, "$GPGGA,%f,%lf,%c,%lf,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        //pc.printf("GPGGA Fix taken at: %f, Latitude: %f %c, Longitude: %f %c, Fix quality: %d, Number of sat: %d, Altitude: %f M\n", timefix, latitude, ns, longitude, ew, fq, nst, altitude);
    }
    
    // Satellite status
    if(strncmp(cmd,"$GPGSA", 6) == 0) 
    {
        sscanf(cmd, "$GPGSA,%c,%d,%d", &tf, &fix, &nst);
        //pc.printf("GPGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPGLL", 6) == 0) 
    {
        sscanf(cmd, "$GPGLL,%lf,%c,%lf,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        //pc.printf("GPGLL Latitude: %f %c, Longitude: %f %c, Fix taken at: %f\n\r", latitude/100.0, ns, longitude/100.0, ew, timefix);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPRMC", 6) == 0) 
    {
        sscanf(cmd, "$GPRMC,%f,%c,%lf,%c,%lf,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
        //pc.printf("GPRMC Fix taken at: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n", timefix, status, latitude, ns, longitude, ew, speed, date);
    }
}
void check(){
    if(latitude!=0){
    if(abs(latitude*1000 - lat_ch*1000) <= 20 && abs(longitude*1000 - long_ch*1000) <=20 ){
        alert = 1;
        wait(2);
        alert = 0;
        lat_ch = 0;
        long_ch = 0;
    }
    }    
}
