#include "mbed.h"
#include "TextLCD.h"
#include "SongPlayer.h"
#include "Speaker.h"
 
Serial leftSensor(p9, p10);  // tx, rx
Serial rightSensor(p13, p14);  // tx, rx
Serial gameOverSensor(p28, p27);  // tx, rx
PwmOut IRLED(p21);
DigitalIn leftButton(p7);
DigitalIn middleButton(p8);
DigitalIn rightButton(p11);
Timer t;
bool check = false;
TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD16x2); 
DigitalOut leftLED(p5);
DigitalOut rightLED(p6);
Serial pc(USBTX, USBRX);
int score = 0;
bool leftLEDOn = false;
bool rightLEDOn = false;

float note[1]= {1568.0};
float duration[1]= {0.25};
                    
Speaker mySpeaker(p25);
 
int main() {
    IRLED.period(1.0/38000.0);
    IRLED = 0.5;
    leftSensor.baud(2400);
    rightSensor.baud(2400);
    gameOverSensor.baud(2400);
    t.start();
    lcd.printf("MBED PINBALL\nSCORE:%010d", score);
    
    //put switches in pullup mode
    leftButton.mode(PullUp);
    middleButton.mode(PullUp);
    rightButton.mode(PullUp);
    
    wait(0.05);
    leftLED = 0;
    rightLED = 0;
        
    while(1) {
        //score += 1;
        leftSensor.putc(0);
        rightSensor.putc(0);
        gameOverSensor.putc(0);
        
        //handle switch being pressed (in any of the 5 directions)
        if (leftButton == 0)
        {
            //add points here?
            score += 2000;
        }
        
        if (middleButton == 0)
        {
            //add points here?
            score += 2000;
        }
        
        if (rightButton == 0)
        {
            //add points here?
            score += 2000;
        }
        
           
        if (leftSensor.readable())
        {
            leftSensor.getc();
        }
        
        else if (!leftSensor.readable() && (t.read() > 0.5 || check)) {
            //pinball went through left side
            if (!leftLEDOn)
            {
                t.stop();
                check = true;
                leftLED = 1;
                leftLEDOn = true;
                if (rightLED == 1)
                {
                    //both leds are on give points and turn off leds
                    score += 1000;
                    wait(1.0);
                    leftLED = 0;
                    rightLED = 0;
                    leftLEDOn = false;
                    rightLEDOn = false;
                    t.reset();
                    t.start();
                    check = false;
                }
            }
        }
        
        if (rightSensor.readable())
        {
            rightSensor.getc();
        }
        
        else if(!rightSensor.readable() && (t.read() > 0.5 || check)) {
            if (!rightLEDOn)
            {
                //pinball went through right side
                t.stop();
                check = true;
                rightLED = 1;
                rightLEDOn = true;
                if (leftLED == 1)
                {
                    //both leds are on give points and turn off leds
                    score += 1000;
                    wait(1.0);
                    leftLED = 0;
                    rightLED = 0;
                    leftLEDOn = false;
                    rightLEDOn = false;
                    t.reset();
                    t.start();
                    check = false;
                }
            }
        }
        
        if (gameOverSensor.readable())
        {
            gameOverSensor.getc();
        }
        
        else if(!gameOverSensor.readable() && (t.read() > 0.5 || check)) {
            //game over
            t.stop();
            check = true;
            lcd.cls();
            lcd.printf("GAME OVER\nSCORE:%010d", score);
            //play game over sound
            mySpeaker.PlayNote(277.1826, 0.25, 0.5);
            mySpeaker.PlayNote(261.6256, 0.5, 0.5);
            mySpeaker.PlayNote(174.6141, 1.0, 0.5);
            leftLED = 0;
            rightLED = 0;
            break;
        }
                
        lcd.printf("MBED PINBALL\nSCORE:%010d", score); 
    }
}