#include "mbed.h"
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#include "WIZnetInterface.h"

unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x07,0x07};

char* Public_Key = "g1WVqxqKqNtr2AVG6424TVvoyopy";
char* Private_Key = "dRbwA0AeAWf7DqyMOdDdHzlA9Av9";
char* ServerIP = "192.168.44.70";


MMA8451Q acc1(PTE25, PTE24, MMA8451_I2C_ADDRESS);
Serial pc(USBTX,USBRX);//pc is object of class serial hence anything used a pc.function then that function is a part of the class serial
Serial psoc(PTE22,PTE23);
BusOut myled(LED1,LED2,LED3);
SPI spi(PTD2,PTD3,PTD1);
WIZnetInterface ethernet(&spi,PTD0,PTA20);
AnalogIn temp(PTC1);

char buffer1[20];

char buffer2[20];
int16_t z=0;
int16_t x=0;
int16_t y=0; 

int main() 
{
    
    myled=0xff;;
    char choice;
    pc.printf("Hello Forum\r\n");
    while(true) 
    {
        if(psoc.readable())
        
        {   myled=0x02;
            choice =psoc.getc();
         
           switch(choice)
          {case 'D': {myled=0x06;
                     if(psoc.readable());
                      {psoc.gets(buffer1,20);
                       pc.printf("LDR= %s\r\n",buffer1);
                       myled=0x06;}   
                      }       
           break;
           
           case 'M': {myled=0x05;
                     if(psoc.readable());
                     {psoc.gets(buffer2,20);
                     buffer2=buffer2/10
                      pc.printf("LM35= %s\r\n",buffer2); 
                      myled=0x05;}    
                     } 
           break;
           
           case 'X': {
                      int s=5;   
                      x= -s*(acc1.getAccY());
                      pc.printf("x=%d \r\n",x);
                      myled=0x03;}          
           break;
           
           case 'Y': {
                      int s=5;   
                      y= s*acc1.getAccX();
                      pc.printf(" y=%d \r\n",y);
                      myled=0x03;}          
           break;
          
           case 'Z': {
                     int s=5;   
                     z= s*acc1.getAccZ();
                     pc.printf(" z=%d\r\n",z);
                     myled=0x03;}          
           break;
          
           default: myled=0x01;
           break;
          }
          //Set serial port baudrate speed: 115200
    pc.baud(115200);
    pc.printf("Start\r\n");
    
    while(1) {
        int ret = ethernet.init(MAC_Addr);
        
        if (!ret) {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            } else {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } else {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }  
    
    TCPSocketConnection sock;
    sock.connect(ServerIP, 8080);
    if(sock.is_connected())
        printf("Socket Connected\n\r");
    else
        printf("Socket NoT Connected\n\r");
    
    char buffer[300];
    int ret_t;
    
    char http_cmd[256]; 

        sprintf(http_cmd,"GET /input/%s?private_key=%s&LDR=%s HTTP/1.0\n\n",Public_Key,Private_Key,counter);
        printf("Running - %s\r\n",http_cmd);
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
        
        ret_t = sock.receive(buffer, sizeof(buffer)-1);
        buffer[ret_t] = '\0';
        printf("Received %d chars from server:\n%s\r\n", ret_t, buffer);
        
    sock.close();
    
    ethernet.disconnect();
    printf("Socket Closed");
    
    while(1) {}
        }
     }         
}
