#include "mbed.h"
#include "RF24.h"
#include "ILI9486.h"
#include "DisplayBace.h"
#include "SDFileSystem.h"
#include "JPEG_Converter.h"

#include "HTTPServer.h"
#include "FsHandler.h"

#include "rtos.h"

#include "stdio.h"
#include "string"
#include "Arial12x12.h"
#include "Arial28x28.h"
#include "Arial24x23.h"
//#include "Terminal6x8.h"
#include "Arial43x48_numb.h"
#include "pict.h"
#include "pavement_48x34.h"
#include "Touch.h"

#include "camera.h"
#include "EthernetInterface.h"

//Initialization
Serial uart(USBTX, USBRX);
ILI9486 myLCD(SPI_16, 16000000, P4_6, NC, P4_4, P4_5, P2_14, P8_1,"myLCD"); // Spi 16bit, 12MHz, mosi, miso, sclk, cs, reset, dc
TouchScreenADS7843 TP(P4_6 ,P4_7 ,P4_4 ,P2_9 ,P7_15, &myLCD);// ADS7843 -> mosi, miso, sclk, cs, irq, SPI_myLCD
SDFileSystem sd(P8_5, P8_6, P8_3, P8_4, "sd");
RF24 radio(P10_14,P10_15, P10_12,P8_14, P10_13); // mosi, miso, sck, csn, ce, irq

AnalogIn   temp(A4);
DigitalOut led3(LED3);
int temp_count=0,in_pic=0;

struct Screen {
    int16_t title[60*320];
    int titlex,titley;
    int16_t logo[80*320];
    int logox,logoy;
    int16_t hc[157*156];
    int hcx,hcy,hch,hcw;
    int16_t aut[158*156];
    int autx,auty,autw,auth;
    int16_t sec[157*158];
    int secx,secy,secw,sech;
    int16_t ind[158*158];
    int indx,indy,indw,indh;
    int indsize;
    int secsize;
    int autsize;
    int hcsize;
    int logosize;
    int titlesize;
} dis_nav;

//Variables
unsigned short backgroundcolor=Black;
unsigned short foregroundcolor=Red;
int pos[4];
int16_t colors[16]= {
    0x000F,0x0000,0x03E0,0x03EF,0x7800,0x780F,0x7BE0,0xC618,0x7BEF,0x001F,0x07E0,0x07FF,0xF800,0xF81F,0xFFE0,0xFFFF
};
int color_count=0;
int cam_sel=0;
int ind_speed=0;
int ind_of=0;
int16_t prev_col=0;
EthernetInterface network;
HTTPServer svr;
TCPSocketServer rf_server;
TCPSocketConnection client;


static unsigned short col_buf[PIXEL_VW][PIXEL_HW]__attribute((section("NC_BSS"),aligned(8)));  //8 bytes aligned!;
static uint8_t JCUBuffer_OUTPUT[PIXEL_HW * VIDEO_BUFFER_HEIGHT*4]__attribute((section("NC_BSS"),aligned(8)));  //8 bytes aligned!;



//Init LCD and touch
void Init_lcd_touch()
{
    Matrix matrix;
    Coordinate ScreenSample[3];
    myLCD.set_orientation(2);
    // myLCD.claim(stdout);      // send stdout to the LCD display
    //myLCD.claim(stderr);      // send stderr to the LCD display
    myLCD.background(backgroundcolor);    // set background to black
    myLCD.foreground(foregroundcolor);    // set chars to white
    myLCD.cls();
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.locate(0,20);
    TP.TouchPanel_Calibrate();

    //  myLCD.set_orientation(0);
    // Display calibration values
    TP.GetCalibration(&matrix, &ScreenSample[0]);
    myLCD.cls();
    myLCD.locate(0,20);
    // read calibration results
    printf("Read calibration results.\n");
    printf("matrix.An = %d\n", matrix.An);
    printf("matrix.Bn = %d\n", matrix.Bn);
    printf("matrix.Cn = %d\n", matrix.Cn);
    printf("matrix.Dn = %d\n", matrix.Dn);
    printf("matrix.En = %d\n", matrix.En);
    printf("matrix.Fn = %d\n", matrix.Fn);
    printf("matrix.Di = %d\n", matrix.Divider);
    for (int i=0; i<3; i++)
        printf("sample x[%d] = %d\nsample y[%d] = %d\n", i, ScreenSample[i].x, i, ScreenSample[i].y);
    // Write calibration results
    printf("\nWrite calibration results...\n");
    TP.SetCalibration(&matrix, &ScreenSample[0]);
    printf("Done.\nTouch panel to start\n");
    while(TP._tp_irq);
}

int get_xy()
{
    int x=0;
    if(!TP._tp_irq) {
        if (TP.Read_Ads7843()) {
            TP.getDisplayPoint() ;
            //myLCD.cls();
            //myLCD.locate(20,0);
            // TP.TP_DrawPoint(TP.display.x,TP.display.y, Blue);
            x=1;
        }
    }
    wait(0.1);
    return x;
}

void init_dis_nav()
{
    dis_nav.indsize=158*158;
    dis_nav.secsize=157*158;
    dis_nav.autsize=158*156;
    dis_nav.hcsize=157*156;
    dis_nav.logosize=80*320;
    dis_nav.titlesize=60*320;
    myLCD.BMP_16(0,0,"/sd/gui/title.bmp",dis_nav.title);
    dis_nav.titlex=0;
    dis_nav.titley=0;
    myLCD.BMP_16(0,400,"/sd/gui/logo.bmp",dis_nav.logo);
    dis_nav.logox=0;
    dis_nav.logoy=400;
    myLCD.BMP_16(0,81,"/sd/gui/hc.bmp",dis_nav.hc);
    dis_nav.hcx=0;
    dis_nav.hcy=81;
    dis_nav.hcw=157;
    dis_nav.hch=158;
    //myLCD.fillrect(161,81,319,237,White);
    myLCD.BMP_16(dis_nav.autx=161,dis_nav.auty=81,"/sd/gui/auto.bmp",dis_nav.aut);
    dis_nav.autw=158;
    dis_nav.auth=156;
    //myLCD.fillrect(0,241,157,399,White);
    myLCD.BMP_16(dis_nav.secx=0,dis_nav.secy=241,"/sd/gui/secu.bmp",dis_nav.sec);
    dis_nav.secw=157;
    dis_nav.sech=158;
    //myLCD.fillrect(161,241,319,399,White);
    myLCD.BMP_16(dis_nav.indx=161,dis_nav.indy=241,"/sd/gui/indus.bmp",dis_nav.ind);
    dis_nav.indw=158;
    dis_nav.indh=158;
}

void init_gui()
{
    init_dis_nav();
    myLCD.cls();
    myLCD.BMP_disp(dis_nav.titlex,dis_nav.titley,dis_nav.title,dis_nav.titlesize,0,60);
    myLCD.BMP_disp(dis_nav.logox,dis_nav.logoy,dis_nav.logo,dis_nav.logosize,0,80);
    myLCD.rect(0,60,319,80,Red);
    myLCD.rect(1,61,318,79,Red);
    myLCD.locate(4,65);
    // myLCD.fillrect(0,81,157,237,White);
    myLCD.BMP_disp(dis_nav.hcx,dis_nav.hcy,dis_nav.hc,dis_nav.hcsize,dis_nav.hcw,dis_nav.hch);
    //myLCD.fillrect(161,81,319,237,White);
    myLCD.BMP_disp(dis_nav.autx,dis_nav.auty,dis_nav.aut,dis_nav.autsize,dis_nav.autw,dis_nav.auth);
    //myLCD.fillrect(0,241,157,399,White);
    myLCD.BMP_disp(dis_nav.secx,dis_nav.secy,dis_nav.sec,dis_nav.secsize,dis_nav.secw,dis_nav.sech);
    //myLCD.fillrect(161,241,319,399,White);
    myLCD.BMP_disp(dis_nav.indx,dis_nav.indy,dis_nav.ind,dis_nav.indsize,dis_nav.indw,dis_nav.indh);
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.printf("Select a menu");
    for(int i=158; i<160; i++) {
        myLCD.line(i,80,i,400,Blue);
    }
    for(int i=238; i<240; i++) {
        myLCD.line(0,i,319,i,Blue);
    }

}


void set_ind(int o_f,int speed)
{
    uint8_t add[]= {0xe7,0xe7,0xe7,0xe7,0xe8};
    radio.stopListening();
    radio.openWritingPipe(add);
    wait_ms(2);

    int count=0;
    char c[20];
    sprintf(c,"NEO,1,%d,%d,1\n",o_f,speed);
    myLCD.fillrect(2,62,317,78,Black);
    myLCD.locate(4,65);
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.printf("Writing %s",c);
    while (!radio.write( &c, 20 )) {
        myLCD.fillrect(2,62,317,78,Black);
        myLCD.locate(4,65);
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.printf("Failed");
        count++;
        if(count>=10)
            break;
        wait(0.1);
    }
    wait_ms(2);
    radio.startListening();
    wait_ms(1);
}

void set_color(char r,char g,char b)
{
    uint8_t add[]= {0xe7,0xe7,0xe7,0xe8,0xe8};
    radio.stopListening();
    radio.openWritingPipe(add);
    wait_ms(2);

    int count=0;
    char c[20];
    sprintf(c,"N,5,%d,%d,%d,%d,1\n",0x01,(r<<3),(g<<2),(b<<3));
    myLCD.fillrect(2,62,317,78,Black);
    myLCD.locate(4,65);
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.printf("Writing %s",c);
    while (!radio.write( &c, 20 )) {
        myLCD.fillrect(2,62,317,78,Black);
        myLCD.locate(4,65);
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.printf("Failed");
        count++;
        if(count>=10)
            break;
        wait(0.1);
    }
    wait_ms(2);
    radio.startListening();
    wait_ms(1);
}

void take_pic_jpg(int name)
{
    led2=1;
    JPEG_Converter  encoder;
    JPEG_Converter::bitmap_buff_info_t  aBitmapData;
    size_t EncodeSize;
    FILE * wr_fp = NULL;

    aBitmapData.width           = PIXEL_HW;
    aBitmapData.height          = VIDEO_BUFFER_HEIGHT;
    aBitmapData.format          = JPEG_Converter::WR_RD_YCbCr422;   //YCbCr[0] & ARGB8888[1] is 4byte, not RGB565[2] is 2byte
    aBitmapData.buffer_address  = (void *)save_buff_addr;
    if (encoder.encode(&aBitmapData, JCUBuffer_OUTPUT, &EncodeSize) == JPEG_Converter::JPEG_CONV_OK) {

        char c[20];
        sprintf(c,"/sd/abc%d.jpg",name);
        wr_fp = fopen(c, "w");
        fwrite(JCUBuffer_OUTPUT, sizeof(char), EncodeSize, wr_fp);
        fclose(wr_fp);
        led2=0;
    }

}

unsigned short yuvtorgb(int y,int u,int v)
{
    unsigned short rgb=0;
    int r = y + (1.402 * (v-128));
    int g = y - (0.34414 * (u-128)) - (0.71414 * (v-128));
    int b = y + (1.772* (u-128));
    if(r<0)r=0;
    else if(r>255)r=255;
    if(g<0)g=0;
    else if(g>255)g=255;
    if(b<0)b=0;
    else if(b>255)b=255;
    r=r>>3;
    g=g>>2;
    b=b>>3;
    rgb=(r<<11)|(g<<5)|b;
    return rgb;

}
void take_picture()
{
    // uint8_t col_buf[PIXEL_HW * VIDEO_BUFFER_HEIGHT*4];
    pos[2]=pos[1]=pos[0]=pos[3]=0;
    DisplayBase::graphics_error_t error;
    in_pic=1;
    led1 = 1;

    if (write_buff_addr == FrameBuffer_Video_A) {
        write_buff_addr = FrameBuffer_Video_B;
        save_buff_addr  = FrameBuffer_Video_A;
    } else {
        write_buff_addr = FrameBuffer_Video_A;
        save_buff_addr  = FrameBuffer_Video_B;
    }

    /* Change write buffer */
    error = Display.Video_Write_Change(
                VIDEO_INPUT_CH,
                write_buff_addr,
                VIDEO_BUFFER_STRIDE);
    if (error != DisplayBase::GRAPHICS_OK) {
        uart.printf("Line %d, error %d\n", __LINE__, error);
        while (1);
    }
    /* Wait 2 Vfield(Top or bottom field) */

    WaitVfield(2);

    myLCD.WindowMax();
    int j=0,k=0;
    for(int i=0; i<VIDEO_BUFFER_STRIDE * VIDEO_BUFFER_HEIGHT; i++) {
        unsigned short rgb1=0,rgb2=0;
        int yb=save_buff_addr[i];
        int v=save_buff_addr[i+1];
        int ya=save_buff_addr[i+2];
        int u=save_buff_addr[i+3];
        i=i+3;
        rgb1=yuvtorgb(ya,u,v);
        rgb2=yuvtorgb(yb,u,v);
        col_buf[j][k++]=rgb2;
        col_buf[j][k++]=rgb1;
        if(k==320) {
            j++;
            k=0;
        }
    }

    for(int i=0; i<480; i++) {
        for(int j=0; j<320; j++) {
            for(int k=3; k>=0; k--) {
                myLCD.wr_gram(col_buf[i][k+j]);
            }
            j=j+3;
        }
    }

    led1=0;

    take_pic_jpg(10);

}


void navigate(int x,int y)
{
    if(in_pic==1) {
        in_pic=0;
        myLCD.cls();
        myLCD.BMP_disp(dis_nav.titlex,dis_nav.titley,dis_nav.title,dis_nav.titlesize,0,60);
        myLCD.BMP_disp(dis_nav.logox,dis_nav.logoy,dis_nav.logo,dis_nav.logosize,0,80);
        myLCD.rect(0,60,319,80,Red);
        myLCD.rect(1,61,318,79,Red);
        myLCD.BMP_disp(dis_nav.indx,dis_nav.indy,dis_nav.ind,dis_nav.indsize,dis_nav.indw,dis_nav.indh);
        myLCD.BMP_disp(dis_nav.secx,dis_nav.secy,dis_nav.sec,dis_nav.secsize,dis_nav.secw,dis_nav.sech);
        myLCD.BMP_disp(dis_nav.autx,dis_nav.auty,dis_nav.aut,dis_nav.autsize,dis_nav.autw,dis_nav.auth);
        myLCD.BMP_disp(dis_nav.hcx,dis_nav.hcy,dis_nav.hc,dis_nav.hcsize,dis_nav.hcw,dis_nav.hch);
        pos[0]=pos[1]=pos[2]=pos[3]=0;
        return;
    }
    if(y>85 && y<235) {
        if(x<155) { //Healthcare Navigation
            if(pos[0]==0) {
                myLCD.fillrect(0,81,157,237,Black);
                myLCD.BMP_16(2,82,"/sd/gui/heart.bmp");
                myLCD.BMP_16(2,170,"/sd/gui/temp.bmp");
                myLCD.BMP_16(58,136,"/sd/gui/b_but.bmp");
                myLCD.set_font((unsigned char*) Arial28x28);
                myLCD.foreground(Red);
                //myLCD.set_font_zoom(2,2);
                // myLCD.rect(96,96,144,128,Red);
                //  myLCD.locate(100,100);
                // myLCD.printf("92");
                // myLCD.locate(78,194);
//                myLCD.printf("32");
//                // myLCD.rect(76,188,152,225,Red);
//                myLCD.circle(116,197,3,Red);
//                myLCD.locate(124,194);
//                myLCD.printf("C");
                pos[0]=1;
            } else {
                if(x>58&& x<108 && y>136 && y<176) {
                    myLCD.BMP_disp(dis_nav.hcx,dis_nav.hcy,dis_nav.hc,dis_nav.hcsize,dis_nav.hcw,dis_nav.hch);
                    pos[0]=0;
                }
            }

        } else {
            if(pos[1]==0) { //Automation Navigation
                myLCD.fillrect(161,81,319,237,Black);
                myLCD.BMP_16(280,88,"/sd/gui/b_but.bmp");
                myLCD.BMP_16(207,82,"/sd/gui/bulb.bmp");
                myLCD.circle(190,105,15,White);
                myLCD.fillcircle(190,105,13,prev_col);
                int count=0;
                for(int i=0; i<3; i++) {
                    for(int j=0; j<5; j++) {
                        int a=164+(j*30);
                        int b=138+(i*30);
                        myLCD.fillrect(a,b,a+30,b+30,colors[count++]);
                    }
                }
                pos[1]=1;
            } else {
                if(x>275 && x<319 && y>84 &&y<130) {
                    myLCD.BMP_disp(dis_nav.autx,dis_nav.auty,dis_nav.aut,dis_nav.autsize,dis_nav.autw,dis_nav.auth);
                    pos[1]=0;
                } else if(x>164 && x<319 && y>138 && y<236) {
                    int a=(x-164)/30;
                    int b=(y-138)/30;
                    int c=a+(b*5);
                    myLCD.fillcircle(190,105,13,colors[c]);
                    char r=(char)((colors[c]>>11)&0x1f);
                    char g=(char)((colors[c]>>5)&0x3f);
                    char bl=(char)((colors[c])&0x1f);
                    set_color(r,g,bl);
                    prev_col=colors[c];

                }

            }
        }
    } else if(y>238 && y<400) {
        if(x<155) { //Security Navigation
            if(pos[2]==0) {
                myLCD.fillrect(dis_nav.secx,dis_nav.secy,dis_nav.secw+dis_nav.secx,dis_nav.sech+dis_nav.secy,Black);
                myLCD.BMP_16(10,245,"/sd/gui/d_close.bmp");
                myLCD.BMP_16(113,245,"/sd/gui/b_but.bmp");
                myLCD.rect(10,365,35,390,White);
                myLCD.rect(11,366,34,389,White);
                myLCD.locate(45,365);
                myLCD.set_font((unsigned char*) Arial24x23);
                myLCD.printf("Camera");
                pos[2]=1;
            } else {
                if(x>9 && y >364 && x<36 && y<391) {
                    if(cam_sel==0) {
                        myLCD.fillrect(12,367,33,388,Blue);
                        cam_sel=1;
                    } else {
                        myLCD.fillrect(12,367,33,388,Black);
                        cam_sel=0;
                    }
                } else if(x>112 && y>244 && x<154 && y<286) {
                    myLCD.BMP_disp(dis_nav.secx,dis_nav.secy,dis_nav.sec,dis_nav.secsize,dis_nav.secw,dis_nav.sech);
                    pos[2]=0;
                }
            }


        } else { // Industry
            if(pos[3]==0) {
                myLCD.fillrect(dis_nav.indx,dis_nav.indy,dis_nav.indw+dis_nav.indx,dis_nav.indh+dis_nav.indy,Black);
                myLCD.BMP_16(278,245,"/sd/gui/b_but.bmp");
                myLCD.BMP_16(200,250,"/sd/gui/blower.bmp");
                myLCD.BMP_16(163,345,"/sd/gui/minus.bmp");
                if(ind_of==0)
                    myLCD.BMP_16(214,335,"/sd/gui/b_p_off.bmp");
                else
                    myLCD.BMP_16(214,335,"/sd/gui/b_p_on.bmp");
                myLCD.BMP_16(266,345,"/sd/gui/plus.bmp");
                myLCD.locate(170,270);
                myLCD.set_font((unsigned char*) Arial28x28);
                myLCD.printf("%d",ind_speed);
                pos[3]=1;
            } else {
                if(x>=266 && y>=345 && x<=316 && y<=395) {
                    ind_speed++;
                    if(ind_speed>9)
                        ind_speed=9;

                    set_ind(ind_of,ind_speed);
                    myLCD.locate(170,270);
                    myLCD.set_font((unsigned char*) Arial28x28);
                    myLCD.printf("%d",ind_speed);
                } else if(x>=163 && y>=345 && x<=213 && y<=395) {
                    ind_speed--;
                    if(ind_speed<0)
                        ind_speed=0;
                    set_ind(ind_of,ind_speed);
                    myLCD.locate(170,270);
                    myLCD.set_font((unsigned char*) Arial28x28);
                    myLCD.printf("%d",ind_speed);
                } else if(x>=214 && y>=335 && x<=264 && y<=385) {
                    if(ind_of==0) {
                        myLCD.BMP_16(214,335,"/sd/gui/b_p_on.bmp");
                        ind_of=1;
                        set_ind(ind_of,ind_speed);
                    } else {
                        myLCD.BMP_16(214,335,"/sd/gui/b_p_off.bmp");
                        ind_of=0;
                        set_ind(ind_of,ind_speed);
                    }
                } else if(x>=278 && y>=245 && x<=318 && y<=285) {

                    myLCD.BMP_disp(dis_nav.indx,dis_nav.indy,dis_nav.ind,dis_nav.indsize,dis_nav.indw,dis_nav.indh);
                    pos[3]=0;
                }
            }

        }
    } else if(y>400) {
        myLCD.BMP_disp(dis_nav.indx,dis_nav.indy,dis_nav.ind,dis_nav.indsize,dis_nav.indw,dis_nav.indh);
        myLCD.BMP_disp(dis_nav.secx,dis_nav.secy,dis_nav.sec,dis_nav.secsize,dis_nav.secw,dis_nav.sech);
        myLCD.BMP_disp(dis_nav.autx,dis_nav.auty,dis_nav.aut,dis_nav.autsize,dis_nav.autw,dis_nav.auth);
        myLCD.BMP_disp(dis_nav.hcx,dis_nav.hcy,dis_nav.hc,dis_nav.hcsize,dis_nav.hcw,dis_nav.hch);
        pos[0]=pos[1]=pos[2]=pos[3]=0;
    }
    wait(0.1);
}

void init_radio()
{
    uint8_t hb[]= {0xe7,0xe7,0xe7,0xe8,0xe9};
    uint8_t sec[]= {0xe8,0xe7,0xe7,0xe8,0xe9};
    radio.begin();
    radio.setAutoAck(1);
    radio.setChannel(100);
    radio.setDataRate(RF24_1MBPS);
    radio.enableAckPayload();               // Allow optional ack payloads
    radio.setRetries(15, 15);
    radio.setPALevel(RF24_PA_MAX);
    radio.enableDynamicPayloads();
    radio.openReadingPipe(1,hb);
    radio.openReadingPipe(2,sec);
    radio.startListening();

}

void cli_decode(char *c)
{
    int count=0;
    string s[10];
    char c1[20];
    int s_count=0;
    for(int i=0; i<20; i++) {
        if(c[i]=='\n')
            break;
        if(c[i]==',') {
            s_count++;
            continue;
        }
        s[s_count]+=c[i];
    }

    if(s[0]!="NEO"&&s[0]!="N")
        return;
    myLCD.fillrect(2,62,317,78,Black);
    myLCD.locate(4,65);
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.printf("Writing %s",c);
    if(s[1]=="1") {
        sprintf(c1,"%s,%s,%s,%s,1\n",s[0].c_str(),s[1].c_str(),s[2].c_str(),s[3].c_str());
        uint8_t add[]= {0xe7,0xe7,0xe7,0xe7,0xe8};
        radio.stopListening();
        radio.openWritingPipe(add);
        wait_ms(2);
        while (!radio.write( &c1, 20 )) {
            myLCD.fillrect(2,62,317,78,Black);
            myLCD.locate(4,65);
            myLCD.set_font((unsigned char*) Arial12x12);
            myLCD.printf("Failed");
            count++;
            if(count>=10)
                break;
            wait(0.1);
        }
        wait_ms(2);
        radio.startListening();
        wait_ms(1);

    } else if(s[1]=="5") {
        sprintf(c1,"%s,%s,%s,%s,%s,%s,1\n",s[0].c_str(),s[1].c_str(),s[2].c_str(),s[3].c_str(),s[4].c_str(),s[5].c_str());
        uint8_t add[]= {0xe7,0xe7,0xe7,0xe8,0xe8};
        radio.stopListening();
        radio.openWritingPipe(add);
        wait_ms(2);
        int count=0;
        while (!radio.write( &c1, 20 )) {
            myLCD.fillrect(2,62,317,78,Black);
            myLCD.locate(4,65);
            myLCD.set_font((unsigned char*) Arial12x12);
            myLCD.printf("Failed");
            count++;
            if(count>=10)
                break;
            wait(0.1);
        }
        wait_ms(2);
        radio.startListening();
        wait_ms(1);


    }
}

void rf_decode(char *c)
{
    string s[10];
    c[19]='\n';

    int s_count=0;
    for(int i=0; i<20; i++) {
        if(c[i]=='\n')
            break;
        if(c[i]==',') {
            s_count++;
            continue;
        }
        s[s_count]+=c[i];
    }
    if(s[0]!="NEO")
        return;
    char send_cli[20];
    sprintf(send_cli,"%s,%s,%s,%s,%s\n",s[0].c_str(),s[1].c_str(),s[2].c_str(),s[3].c_str(),"1");
    if(client.is_connected()==true) {
        client.send(send_cli,strlen(send_cli));
    }

    if(s[1]=="2") {

        if(pos[0]==1) {
            myLCD.set_font((unsigned char*) Arial28x28);
            myLCD.locate(86,100);
            if(atoi(s[2].c_str())<100)
                myLCD.printf("0%s",s[2].c_str());
            else
                myLCD.printf("%s",s[2].c_str());
        }
    } else if(s[1]=="3") {
        if(pos[2]==1) {
            if(s[2]=="1") {
                myLCD.BMP_16(10,245,"/sd/gui/d_open.bmp");
                if(cam_sel==1)
                    take_picture();
            } else
                myLCD.BMP_16(10,245,"/sd/gui/d_close.bmp");
        }
    }

}


void init_internet()
{
    network.init("192.168.0.100","255.255.255.0","192.168.0.254"); //Use DHCP
    network.connect();
    myLCD.fillrect(2,62,317,78,Black);
    myLCD.locate(4,65);
    myLCD.set_font((unsigned char*) Arial12x12);
    myLCD.printf("IP Address is %s\n", network.getIPAddress());

}

void init_fs()
{
    char indexPage[256];
    sprintf(indexPage,"<HTML><HEAD><META content=\"text/html\" http-equiv=Content-Type><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\" /> </HEAD><BODY><img src=\"abc10.jpg\" alt=\"Smiley face\" height=\"480\" width=\"320\"></BODY></HTML>\r\n\r\n");
    FILE *fp;
    fp = fopen("/sd/index.htm", "w");
    fwrite(indexPage, sizeof(char), strlen(indexPage), fp);
    fclose(fp);
}




void init_m_connect()
{
    if(rf_server.bind(10101)<0) {
        myLCD.fillrect(2,62,317,78,Black);
        myLCD.locate(4,65);
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.printf("Error in RF Server%s\n", network.getIPAddress());
        while(1);
    }
    if(rf_server.listen(1)<0) {
        myLCD.fillrect(2,62,317,78,Black);
        myLCD.locate(4,65);
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.printf("Failed to listen", network.getIPAddress());
        while(1);
    }
    rf_server.set_blocking(false,100);

}

void poll_rfserver()
{
    char a_buf[256];
    if(client.is_connected()==false) {
        led3=0;
        if(rf_server.accept(client)<0) {
            return;
        }
    } else {

        int len=0;
        led3=1;
        client.set_blocking(false,100);
        if((len=client.receive(a_buf,256))>0) {
            a_buf[len+1]='\0';
            a_buf[len]='\n';

            myLCD.fillrect(2,62,317,78,Black);
            myLCD.locate(4,65);
            myLCD.set_font((unsigned char*) Arial12x12);
            myLCD.printf("Received from client %s", a_buf);
            cli_decode(a_buf);
        }
    }

}


int main()
{
    uart.baud (115200);
    Init_lcd_touch();
    init_gui();
    pos[0]=pos[1]=pos[2]=pos[3]=0;
    init_radio();
    init_camera();
    init_internet();
    init_fs();
    HTTPFsRequestHandler::mount("/sd/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");
    if (!svr.start(80,&network)) {
        myLCD.fillrect(2,62,317,78,Black);
        myLCD.locate(4,65);
        myLCD.set_font((unsigned char*) Arial12x12);
        myLCD.printf("Error in http server start", network.getIPAddress());
        while(1);
    }
    init_m_connect();
    char c[20];
    while(1) {
        if(network.getIPAddress()==NULL) {
            init_internet();
            if (!svr.start(80,&network)) {
                myLCD.fillrect(2,62,317,78,Black);
                myLCD.locate(4,65);
                myLCD.set_font((unsigned char*) Arial12x12);
                myLCD.printf("Error in http server start", network.getIPAddress());
                while(1);
            }
            init_m_connect();

        }
        svr.poll();
        poll_rfserver();
        if(get_xy()==1) {
            navigate(TP.display.x,TP.display.y);
        }
        if(radio.available()) {
            while(radio.available()) {
                radio.read(&c,20);
                c[19]='\0';
                if(in_pic!=1) {
                    myLCD.fillrect(2,62,317,78,Black);
                    myLCD.locate(4,65);
                    myLCD.set_font((unsigned char*) Arial12x12);
                    myLCD.printf("Reading %s",c);
                }
                rf_decode(c);
            }
        }
        temp_count++;
        if(temp_count>=10) {
            temp_count=0;
            char c[20];
            float tem=temp.read()*3.3*100;
            sprintf(c,"NEO,5,%2.0f,0,1\n",tem);
            if(client.is_connected()==true) {
                client.send(c,strlen(c));
            }
            if(pos[0]==1 && in_pic!=1) {
                myLCD.set_font((unsigned char*) Arial28x28);

                myLCD.locate(78,194);
                myLCD.printf("%2.0f",tem);
                // myLCD.rect(76,188,152,225,Red);
                myLCD.circle(116,197,3,Red);
                myLCD.locate(124,194);
                myLCD.printf("C");
                pos[0]=1;
            }
        }
    }
}