#include "mbed.h"
#include "MMA8451Q.h"
#include "USBMouse.h"
#include "TSISensor.h"
#include "USBSerial.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
USBMouse mouse;
TSISensor tsi;



int main(void)
 {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    PwmOut gled(LED_GREEN);
    PwmOut bled(LED_BLUE);
    bool TSI_Pressed = false;
    int ButtonPressed = 0; 
    //1=MOUSE_LEFT 2=MOUSE_RIGHT 4=MOUSE_MIDDLE
    unsigned int TSI_Press_Time = 0;

    while (true) 
    { // tsi mouse clicks
        if (tsi.readPercentage() < 0.01) 
        { 
            if (TSI_Pressed == true) 
            {
                if (TSI_Press_Time < 250) 
                {
                    if (ButtonPressed == 1) 
                    {
                        mouse.click(MOUSE_LEFT);
                    }
                    else if (ButtonPressed == 2) 
                    {
                        mouse.click(MOUSE_RIGHT);
                    }
                    else if (ButtonPressed == 4) 
                    {
                        mouse.click(MOUSE_MIDDLE);
                    }
                }
                TSI_Pressed = false;
                TSI_Press_Time = 0;
            }
        }
        else if (tsi.readPercentage() < 0.25) 
        { 
            if (TSI_Pressed == false) 
            {
                TSI_Pressed = true;
                ButtonPressed = 2;
            }
        }
        else if (tsi.readPercentage() < 0.5) 
        { 
            if (TSI_Pressed == false) 
            {
                TSI_Pressed = true;
                ButtonPressed = 4;
            }
        } 
        else 
        {
            if (TSI_Pressed == false) 
            {
                TSI_Pressed = true;
                ButtonPressed = 1;
            }
        }
        if (TSI_Pressed == true)
         {
            TSI_Press_Time++;
        }
        
        // mouse control
        float AccY = acc.getAccX();
        float AccX = acc.getAccY();
        bled = 1.0 - abs(AccX);
        gled = 1.0 - abs(AccY);
        signed char x = AccX * -10;
        signed char y = AccY * 10;
        mouse.move(x, y);
        wait(0.001);
        
       
        
    }
}

