#include "mbed.h"
#include "USBHostMSD.h"
#include "TextLCD.h"
#include "SDFileSystem.h"

DigitalOut led(LED1);

TextLCD lcd(p19, p20, p27, p28, p29, p30, TextLCD::LCD20x2); // rs, e, d4-d7
SDFileSystem sd(p5, p6, p7, p8, "sd");
//USBHostMSD msd("usb");

void listdir(void);
void FileCopy(char *, char *);
void copyallusb(void);

void listdir(void) {
    DIR *d;
    struct dirent *p;

    d = opendir("/sd");
    if (d != NULL) {
        while ((p = readdir(d)) != NULL) {
            lcd.cls();
            lcd.printf(" - %s\r\n", p->d_name);
        }
    } else {
        lcd.cls();
        lcd.printf("opening failed, try again\n");
    }
    closedir(d);
}

void FileCopy(char *fsrc , char *ftrgt) { 
    FILE *fs = fopen(fsrc, "rb");
    if(fs == NULL) {
        lcd.cls();
        lcd.printf("couldn't open sd\n");
    }
    FILE *ft = fopen(ftrgt, "wb");
    if(ft == NULL) {
        lcd.cls();
        lcd.printf("couldn't open usb\n");
    }
    while(1) {
    int ch = fgetc(fs);
    if(ch == EOF)
    break;
    else
    fputc(ch, ft);
    }
    fclose(fs);
    fclose(ft); 
}

void copyallusb(void) {
    USBHostMSD msd("usb");
           
    // try to connect a MSD device
    while(!msd.connect()) {
        wait_ms(500);
        lcd.cls();
        lcd.printf("connecting to USB");
     }

    char srstrgt[128];
    char filesrs[128];
    char filetrgt[128];
    DIR *d;
    struct dirent *p;

    d = opendir("/sd/");
    if (d != NULL) {
        lcd.cls();
        lcd.printf("copy starting\n");
        while ((p = readdir(d)) != NULL) {
            sprintf(srstrgt, "%s", p->d_name);
            sprintf(filesrs, "/sd/%s", srstrgt);
            sprintf(filetrgt, "/usb/%s", srstrgt);
            lcd.cls();
            lcd.printf("copying-\n");
            lcd.printf("%s\n", srstrgt);
            FileCopy(filesrs, filetrgt);
        }
        lcd.cls();
        lcd.printf("File copy done!\n");
    } else {
        lcd.printf("No File, try again\n");
    }
    closedir(d);
        
    // if device disconnected, try to connect again
    //if (!msd.connected())
    //break;
}


int main() {
    lcd.cls();
    lcd.printf("JAI MATA DI!\n");
    wait(2);
    copyallusb();
    while(1) {
        led=!led;
        Thread::wait(500);       
    }
}