#include "mbed.h"
#include "rtos.h"

#include "EthernetInterface.h"


    static UDPSocket server;
    static Endpoint client;

    static int estado;

    static int blockcnt, dupcnt;       // block counter, and DUP counter
    static FILE* fp;                   // current file to read or write
    static char sendbuff[516];         // current DATA block;
    static int blocksize;              // last DATA block size while sending
    static char filename[256];         // current (or most recent) filename

class tftpsrv
{

#define ESCUTANDO   0
#define LENDO       1
#define ESCREVENDO  2
#define ERRO        3

protected:

    static void tftpInicia();
    static void tftpPara();
    static void tftpReinicia();
    static void tftpAck(int val);
    static void tftpErr(char* msg);
    static int tftpModo(char* buff);
    static void tftpGetBlock();
    static void tftpSendBlock();
    static void tftpLer(char* buff);
    static void tftpEscrever(char* buff);
    static void tftpEscutando(char* buff);
    static void tftpLendo(char *buff);
    static void tftpEscrevendo(int tam, char *buff);
    static void tftpVai();

public:

    static void tftpsrv_Thread(void const* arg);

};
