/* 
    Projeto teste de Enviar dados coletados sem calcular a FFT.
    Aquisição das amostras realizada sem DMA
    
*/

#define MSGWINDOW "Version 5"

#include <stdio.h>

#include "mbed.h"
#include "rtos.h"
#include "cmsis_os.h"
#include "EthernetInterface.h"
#include "Settings.h"
#include "Capture.h"
#include "Http_post.h"
#include "SignalProcessor.h"
#include "EventDetector.h"
#include "limites.h"

#include "TelnetServer.h"

#include "tftpsrv.h"
#include "ntpc.h"

#include "PmedLog.h"

#include "NTPClient.h"

#include "whatchdog.h"

EthernetInterface eth;
Watchdog wdt;

Semaphore tranca(1);

void InitializeEthernetLink()
{
    if(Settings::get_Dhcp())
        //EthernetIf::Initialize(); //Use DHCP
        eth.init(); //Use DHCP
    else
        //EthernetIf::Initialize(Settings::get_IpAddress(),Settings::get_Netmask(),Settings::get_Gateway());
        eth.init(Settings::get_IpAddress(),Settings::get_Netmask(),Settings::get_Gateway());
        
    //EthernetIf::Connect();
    eth.connect();
    //printf("IP Address is %s\n", EthernetIf::get_IpAddress());
    printf("IP Address is NEW %s\n", eth.getIPAddress());
}

int main() {
    
    
    float inicio, fim, maior, menor, dif;
    float inicioc, fimc, maiorc, menorc, difc;
    Timer t,tc;
    /* 
    if ((LPC_WDT->WDMOD >> 2) & 1){
        //myled4 = 1; 
        PmedLog::WriteEntry(PMEDLOG_INITIALIZINGWDT);
    }
    else{        
        //myled3 = 1;
        PmedLog::WriteEntry(PMEDLOG_INITIALIZING);
    }*/

    printf("\r\n %s \r\n", MSGWINDOW);
    
    FILE *f;
    
    Settings::ReadFile();
    printf("\r\n\nCANAL\tOFFSET\t\tGAIN");

    InitializeEthernetLink();
    printf("Inicializou link Ethernet\n");
    
    //Start HTTP POST service
    Thread http_post(HttpPost::HttpPost_Thread);        
    
        
    //Start Telnet Service
    //Thread telnetserver(TelnetServer::TelnetServer_Thread);
    
    //Start TFTP Service    
    //Thread tftpsrv(tftpsrv::tftpsrv_Thread);
    
    //Start NTP Client for refresh time
    //Thread ntpc(ntpc::ntpc_Thread);
    time_t tempo = time(NULL);
    if ((tempo+60) < 1420077600) set_time(1420077600);
    
   // ntpClient.setTime("192.168.103.101");
    
    DisplayRAMBanks();
        
    printf(PMEDLOG_INITIALIZINGWDT);
    printf("\n\n");
            
    //PmedLog::WriteEntry(PMEDLOG_STARTED);
    
    /* start test WatchDog */

    int n = 0;
    //int tatual, tnovo;
    float rms[NUMBER_OF_CHANNELS], mv2[NUMBER_OF_CHANNELS];
    int under[NUMBER_OF_CHANNELS], over[NUMBER_OF_CHANNELS];
    
    //wdt.kick(10.0);  
    
    Capture::InitializeAD();
    int cont1 = 0; 
    
    while(1)    
    {
        /*tranca.wait();
        t.start();
        inicio = t.read();
          */      
        //get sample values from 6 channels
        Capture::AcquireValues();
        
        fim = t.read();
        dif = fim-inicio;
        
        if (n == 0)
            maior = menor = dif;
            
        if (dif > maior)
            maior = dif;
        if (dif < menor)
            menor = dif;         
        t.reset();
        t.stop();           
        //tranca.release();
        
        //tranca.wait();
        tc.start();
        inicioc = tc.read();
        // Calcula o RMS dos 6 canais
        SignalProcessor::CalculateRMSBulk(rms, mv2, under, over);
        /*
        printf("\r\n\nCANAL\tOFFSET\t\tGAIN");
        for (int i=0;i<6;i++)
        {
            printf("\r\n%d\t%d\t\t%4.2f", i, Settings::get_Offset(i), Settings::get_Gain(i));
        }
        
        
        printf("\r\n\n\tRMS\t\tMV2\t\tUNDER\t\tOVER");
        for (int i=0;i<6;i++)
        {
            printf("\r\n%d\t%4.2f\t\t%4.2f\t\t%d\t\t%d", i, rms[i], mv2[i], under[i], over[i]);
        }
        printf("\n");
        */
        
        fimc = tc.read();
        difc = fimc-inicioc;
        
        if (n == 0)
            maiorc = menorc = difc;
            
        if (difc > maiorc)
            maiorc = difc;
        if (difc < menorc)
            menorc = difc;                    
                
        for(int i=0;i<6;i++){
            EventDetector::get_Detector(i).ProcessEvent(rms[i], mv2[i], under[i], over[i]);
        }

        n++;
        if(n % 60 == 0)
        {
            printf("%.2f %.0f %.2f %.0f\t%.2f %.0f %.2f %.0f\t%.2f %.0f %.2f %.0f\n",rms[0], mv2[0],rms[1],mv2[1],rms[2],mv2[2],rms[3],mv2[3],rms[4],mv2[4],rms[5],mv2[5]);
            //led1 = !led1;            
         //   n=0;    
                                    
            PmedLog::Mark();            
        }
        
        if (n % 600 == 0){
            printf("Captura: Maior %f Menor %f\tCalculo Maior %f Menor %f\n", maior, menor, maiorc, menorc);                               
        }
        
        // End of main loop so "kick" to reset watchdog timer and avoid a reset
        //wdt.kick();        
        tc.reset();
        tc.stop();
        //tranca.release();
    }    
       
    while(1){//never reaches here  
        PmedLog::WriteEntry(PMEDLOG_WRONGCODE);
        printf("Reset\n");
        f = fopen(FILENAMERESET, "a");
        if (f == NULL)            
            f = fopen(FILENAMERESET, "w");
        fprintf(f, "Laco Errado\n");
        fclose(f);
        Thread::yield();
    }
}

