/*
 * Capture.h
 *
 *  Created on: 
 *      Author: 
 */
#include "Capture.h"
#include "Settings.h"


//Semaphore Capture::m_CaptureSemaphore(1); //used to alert the capture thread about a ready capture 
//int Capture::m_BufferIndex;

//__attribute((section("AHBSRAM1"),aligned)) dmaLinkedListNode Capture::m_Nodes[2];// __attribute__((section("AHBSRAM0"))); //this list holds the buffer configuration for the DMA peripheral
__attribute((section("AHBSRAM1"),aligned)) short int Capture::m_AdcBuffers[NUMBER_OF_CHANNELS][NUMBER_OF_SAMPLES];// __attribute__((section("AHBSRAM0")));
bool Capture::flag_capture = 0;
int Capture::cnt_buffer=0;
int Capture::channel_number=0;
int Capture::cnt_interrupt=0;


Serial rfid_serial(p28,p27);
/*
AnalogIn AdcChannel0(CHANNEL0);
AnalogIn AdcChannel1(CHANNEL1);
AnalogIn AdcChannel2(CHANNEL2);
AnalogIn AdcChannel3(CHANNEL3);
AnalogIn AdcChannel4(CHANNEL4);
AnalogIn AdcChannel5(CHANNEL5);
*/
//ADC_CONVERT(m_AdcBuffers[m_BufferIndex][nsamples][nchannel]);

Ticker timer_interrupt;

Timer timer1;

DigitalOut led1(LED1);

short int Capture::GetValue(int nsamples, int nchannel)
{
    return m_AdcBuffers[nchannel][nsamples];
}

void Capture::PutValue(int nsamples, int nchannel, short int value)
{
    m_AdcBuffers[nchannel][nsamples] = value;
}

void Capture::CopyBuffer(int channel, short int *dest)
{
    memcpy(dest, &m_AdcBuffers[channel][0], sizeof(short int) * NUMBER_OF_SAMPLES);
    /*
    for(int i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        dest[i] = GetValue(i,channel);
    }
    */
}

void Capture::InitializeAD()
{
    
    init_adc(200000);                   // Inicializa o AD com a frequencia de amostragem de 200 kHz
    LPC_ADC->ADCR &= ~ADC_MODE_BURST;   // Desabilito o modo burst de captura para utilizar apenas a captura simples
    NVIC_DisableIRQ(TIMER3_IRQn);   // Desabilita a interrupção do Timer3
    
}
    
    
void Capture::AcquireValues()
{
    //timer1.start();
    NVIC_DisableIRQ(TIMER3_IRQn);   // Desabilita a interrupção do Timer3
    timer_interrupt.attach_us(&Capture::FcnTimerInt,11);    // Seta a interrupção do timer3 para cada 11us apontando para a função FcnTimerInt
    cnt_buffer = 0;
    cnt_interrupt = 0;
    flag_capture = 0;   
    channel_number = 0;
    LPC_ADC->ADCR |= ADC_START_NOW; // Habilita a captura do A/D -> Captura Simples
    //printf("\r\nPASSOU do init \n"); 
     
    select_channels(1<<channel_number); // 
     
    
    
    NVIC_EnableIRQ(TIMER3_IRQn); // Habilita a interrupção do timer 3
    for(volatile int i=0; i<100000; i++); // Gasta tempo

    while(!flag_capture);

    
    /*for (int i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        for (int j=0;j<6;j++)
        {
             m_AdcBuffers[j][i] -= get_Offset(j);
             m_AdcBuffers[j][i] /= get_Gain(j);
        }
    }*/

    /*for (int i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        printf("\r\n%d", i);
        
        for (int j=0;j<6;j++)
        {
            float val = 0;
            val = (float)m_AdcBuffers[j][i] - (float)Settings::get_Offset(j);
            val /= (float)Settings::get_Gain(j);
            //printf("\t%f", m_AdcBuffers[j][i]);
            printf("\t%2.2f", val);
        }
    }*/
    //printf("\n");
}

//void Capture::Initialize(){     //AnalogIn adcChannel0; }


void Capture::ReadRFID(int channel,char *rfid)
{
    
    char cmd[4];
    cmd[0] = 'S';
    cmd[1] = '0'+channel;
    cmd[2] = '\n';
    cmd[3] = '\0';
    
    //send
    rfid_serial.puts(cmd);
    
    //receive
    char ch=0;
    char ans[10];
    int cnt=0;
    int tmout=1000;
    while(ch != '\n' && tmout-- && cnt<9)
    {
        if(rfid_serial.readable())
        {
            ch = rfid_serial.getc();
            if(!((ch>='0' && ch<='9') || (ch >= 'A' && ch <= 'F')))ch='0';
            ans[cnt++] = ch;
        }
        else
            wait_ms(1);
        
    }
    ans[cnt-1] = '\0';
    for(int i=0;i<9;i++)
        rfid[i] = ans[i];
    
}

extern "C" void Capture::FcnTimerInt(void)
{
    if (cnt_interrupt < 120)    // Descarta as primeiras leituras para estabilizar as leituras do A/D
    {
        while(!(LPC_ADC->ADGDR>>31));
        m_AdcBuffers[channel_number][0] = ((LPC_ADC->ADGDR>>4)&0xfff);
        if (channel_number < 5)
            {
                channel_number++;
            }
            else
            {
                channel_number = 0;
            }
        cnt_buffer = 0;   
        cnt_interrupt++;
        select_channels(1<<channel_number);
        LPC_ADC->ADCR |= ADC_START_NOW;
        
        
    }
    else    //Armazena as leituras no buffer dos canais
    {
        while(!(LPC_ADC->ADGDR>>31));  // Aguarda o bit de DONE ser setado no registrador ADGDR sinalizando o final de uma captura
        
        if (cnt_buffer < NUMBER_OF_SAMPLES)
        {
            m_AdcBuffers[channel_number][cnt_buffer] =((LPC_ADC->ADGDR>>4)&0xfff);
            if (channel_number < 5)
            {
                channel_number++;
            }
            else
            {
                channel_number = 0;
                cnt_buffer++;
            }   
        }
        else
        {
            
            flag_capture = 1;
            NVIC_DisableIRQ(TIMER3_IRQn);
            //timer_interrupt.detach();
        }
        select_channels(1<<channel_number);
        LPC_ADC->ADCR |= ADC_START_NOW;
   }
}

