/*
 * Settings.h
 *
 *  Created on: 
 *      Author: 
 */
 
#ifndef SETTINGS_H
#define SETTINGS_H

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "mbed.h"
#include "EthernetInterface.h"

#include "Split.h"

#define FILENAME  "/local/pmed.txt"
#define FILENAMERESET "/local/foi.txt"
#define FREQBASE            60U
#define NUMBER_OF_CHANNELS  6U
#define NUMBER_OF_OUTLETS   3U
#define NUMBER_OF_HARMONICS 12U
#define NUMBER_OF_SAMPLES   256U
#define LENGTH_MAIL_BOX     10U
#define MAXTRIES            10U

class Settings
{

    //server URL
    static char* m_serverurl;
    //module number
    static int m_module_number;
    //ip address
    static char* m_ipaddress;
    //netmask
    static char* m_netmask;
    //gateway
    static char* m_gateway;
    //dhcp    
    static int m_dhcp;
    
    //read RFID 
    static int m_ReadRfid;
    
    //gain x6(float)
    static float m_gain[NUMBER_OF_CHANNELS];
    //offset x6(int)
    static int m_offset[NUMBER_OF_CHANNELS];
    //limit x6(float)
    static float m_limit[NUMBER_OF_CHANNELS];
    //outlet x6 (int)
    static int m_outlet_number[NUMBER_OF_CHANNELS];
    //purpose x6(char)
    static char m_purpose[NUMBER_OF_CHANNELS];
    
    //outlet x3(int)
    static int m_outlet[NUMBER_OF_OUTLETS];

    //MaxChannels
    //static int m_MaxChannels;
    //MaxOutlets
    //static int m_MaxOutlets;
    //Samples
    //static int m_Samples;
    //FreqBase
    //static int m_FreqBase;

    //MaxHarmonics
    static int m_MaxHarmonics;

    //EventLimit
    static int m_EventLimit;
    
    //MailBoxLength
    static int m_MBoxLength;
    
    //NumberNeighbors
    //static int m_NumNeighbors;
    
    //Neighbors x3(char [16])
    //static char *m_Neighbor[NEIGHBORS];
    
    //PortTCP
    //static int m_PortTCP;
    
    //Socket to receive requests
    //static TCPSocketServer m_ServerSocket;

    //Socket to send requests
    //static TCPSocketConnection m_Socket[NEIGHBORS];

    //Maximum number of try connect and send
    //static int m_MaxTries;
        
    //Delay time (ms) between 2 tries
    static int m_DelayTry;

    //Delay time (ms) after Send (post)
    static int m_DelaySend;

    // Control the marks behavior in log file
    static bool m_logMarks;
    static int m_logMarksInterval;

public:  

    Settings(); 
      
    static char* get_ServerUrl() { return m_serverurl; }
    static void set_ServerUrl(char *value)
    {
        if(m_serverurl!=NULL) delete m_serverurl;
        int sz = strlen(value)+1;
        m_serverurl = new char[sz];
        strcpy(m_serverurl,value);
    }
    static char* get_IpAddress() { return m_ipaddress; }
    static void set_IpAddress(char *value)
    {
        if(m_ipaddress!=NULL) delete m_ipaddress;
        int sz = strlen(value)+1;
        m_ipaddress = new char[sz];
        strcpy(m_ipaddress,value);
    }
    static char* get_Netmask() { return m_netmask; }
    static void set_Netmask(char *value)
    {
        if(m_netmask!=NULL) delete m_netmask;
        int sz = strlen(value)+1;
        m_netmask = new char[sz];
        strcpy(m_netmask,value);
    }

    static char* get_Gateway() { return m_gateway; }
    static void set_Gateway(char *value)
    {
        if(m_gateway!=NULL)  delete m_gateway;
        int sz = strlen(value)+1;
        m_gateway = new char[sz];
        strcpy(m_gateway,value);
    }
    static int get_Dhcp() { return m_dhcp; }
    static void set_Dhcp(int value) { m_dhcp = value; }
    
    static int get_ReadRfid() { return m_ReadRfid; }
    static void set_ReadRfid(int value) { m_ReadRfid = value; }    
    
    static int get_ModuleNumber() { return m_module_number; }
    static void set_ModuleNumber(int value) { m_module_number = value; }
    
    static float get_Gain(int i) { return m_gain[i]; }
    static void set_Gain(int i, float value) { m_gain[i] = value; }
    static int get_Offset(int i) { return m_offset[i]; }
    static void set_Offset(int i, int value) { m_offset[i] = value; }
    static float get_Limit(int i) { return m_limit[i]; }
    static void set_Limit(int i, float value) { m_limit[i] = value; }
    static int get_OutletNumber(int i) { return m_outlet_number[i]; }
    static void set_OutletNumber(int i, int value) { m_outlet_number[i] = value; }
    static char get_Purpose(int i) { return m_purpose[i]; }
    static void set_Purpose(int i, char value) { m_purpose[i] = value; }
    
    static int get_Outlet(int i) { return m_outlet[i]; }
    static void set_Outlet(int i, int value) { m_outlet[i] = value; }

//    static int get_MaxChannels() { return m_MaxChannels; }
//    static void set_MaxChannels(int value) { m_MaxChannels = value; }
//    static int get_MaxOutlets() { return m_MaxOutlets; }
//    static void set_MaxOutlets(int value) { m_MaxOutlets = value; }
//    static int get_FreqBase() { return m_FreqBase; }
//    static void set_FreqBase(int value) { m_FreqBase = value; }
//    static int get_Samples() { return m_Samples; }
//    static void set_Samples(int value) { m_Samples = value; }    

    static int get_MaxHarmonics() { return m_MaxHarmonics; }
    static void set_MaxHarmonics(int value) { m_MaxHarmonics = value; }    
    static int get_EventLimit() { return m_EventLimit; }
    static void set_EventLimit(int value) { m_EventLimit = value; }    
    static int get_MBoxLength() { return m_MBoxLength; }
    static void set_MBoxLength(int value) { m_MBoxLength = value; }      
    
//    static int get_NumNeighbors() { return m_NumNeighbors; }
//    static void set_NumNeighbors(int value) { m_NumNeighbors = value; }      
//    static char* get_Neighbor(int i) { return m_Neighbor[i]; }    
//    static void set_Neighbor(int i, char *value) 
//    for(...)
//    {
//        if(m_Neighbor[i]!=NULL)  delete m_Neighbor[i];
//        int sz = strlen(value)+1;
//       m_Neighbor[i] = new char[sz];
//        strcpy(m_Neighbor[i],value);
//    }    
//    static int get_PortTCP() { return m_PortTCP; }
//    static void set_PortTCP(int value) { m_PortTCP = value; }         
//    static TCPSocketServer& get_ServerSocket() { return m_ServerSocket; }
//    static void set_ServerSocket(TCPSocketServer value) { m_ServerSocket = value; }             
//    static TCPSocketConnection& get_Socket(int i) { return m_Socket[i]; }
//    static void set_Socket(int i, TCPSocketConnection value) { m_Socket[i] = value; }         
//    static int get_MaxTries() { return m_MaxTries; }
//    static void set_MaxTries(int value) { m_MaxTries = value; }     
    
    static int get_DelayTry() { return m_DelayTry; }
    static void set_DelayTry(int value) { m_DelayTry = value; }     
    
    static int get_DelaySend() { return m_DelaySend; }
    static void set_DelaySend(int value) { m_DelaySend = value; }  

    // Control the marks behavior in log file
    static bool get_LogMarks() { return m_logMarks; }
    static void set_LogMarks(bool value) { m_logMarks = value; }
    static int get_LogMarksInterval() { return m_logMarksInterval; }
    static void set_LogMarksInterval(int value) { m_logMarksInterval = value; }
    
    static void ReadFile();    //Read the config file and places the values in the internal variables
    static void LoadDefaults();
    static void WriteFile();
    static void ShowValues();
    
};

#endif //#ifndef SETTINGS