/*
 * EventDetector.cpp
 *
 *  Created on: 
 *      Author: 
 */
 
 #include "EthernetInterface.h"
 #include "Settings.h"
 #include "Http_post.h"
 
 #include "EventDetector.h"
 
 
 #define MARCA 10
 #define GERAFUGA 0
 #define UMCICLO 16.666666667
 
CaptureMailbox EventDetector::m_EventMailbox;
EventDetector EventDetector::m_Detector[NUMBER_OF_CHANNELS] = {0,1,2,3,4,5};

CaptureEvent::CaptureEvent()
{
}

//void CaptureEvent::Setup(char* rfid,int type,int outlet,float mv,float rms,float gain, int offset,float* sin, float* cos)
void CaptureEvent::Setup(char* rfid, int type, int outlet, float mv, float mv2, float rms, int under, int over, float gain, int offset, int duration, short int *samples)
{
    memcpy(m_RFID,rfid,9);
    m_Type         = type;
    m_OutletNumber = outlet;
    m_MeanValue    = mv;
    m_MV2          = mv2;
    m_RMSValue     = rms;
    m_Under        = under;
    m_Over         = over;
    m_Gain         = gain;
    m_Offset       = offset;
    m_Duration     = duration;
    memcpy(m_Samples, samples, (sizeof(short int) * NUMBER_OF_SAMPLES) );    
}

EventDetector::EventDetector(int ch)
{
    m_Channel = ch;
    m_OutletTriggered = false;
    m_EventCounter = 0;
}
    
//void EventDetector::ProcessEvent(float rmsvalue, int t)
void EventDetector::ProcessEvent(float rmsvalue, float mv2, int under, int over)
{
    int i, tempofuga = 0;   
    short int aux; 
    //short int buf[NUMBER_OF_SAMPLES];
    float newvm;            
    
    if(rmsvalue > Settings::get_Limit(m_Channel))                
    {
        /* Retira o VM das amostras */
        //pega os dados da captura atual
        newvm = 0;
        //Capture::CopyBuffer(m_Channel,buf);
        
        /* Retira o valorMedio de todas as amostras */                                    
        for(i=0; i < NUMBER_OF_SAMPLES; i++){
            aux = Capture::GetValue(i, m_Channel) - mv2;
            Capture::PutValue(i, m_Channel,  aux) ;
            newvm += aux;
        }
                
        if ( m_EventCounter == Settings::get_EventLimit() ){                    
            mv2 = newvm / NUMBER_OF_SAMPLES;
            //printf("Novo valor medio %f RMS original %f\n", mv2, rmsvalue);
        }
            
        rmsvalue = SignalProcessor::CalculateRMS( m_Channel );            
        
        if(!m_OutletTriggered)
        {
            if (rmsvalue > Settings::get_Limit(m_Channel)) {
                if(m_EventCounter < Settings::get_EventLimit() )
                {
                    m_EventCounter++;
                }
                else
                {
                    //printf("Deu evento de liga ou Fuga\n");
                    if (m_Channel % 2 ==  1) // Canais impares sao de diferencial
                        m_tempo.start();
                    m_OutletTriggered = true;  
                    
                    SendMessage(0, rmsvalue, mv2, under, over, 0);
                       
                    //OnTrigger(buf, rmsvalue, mv2, under, over, 0); //TODO: must change the parameter of this function call                    
                    
                    m_EventCounter = 0;
                }
            }
        }
        else
            m_EventCounter = 0;
    }
    else
    {
        if(m_OutletTriggered)
        {
            if(m_EventCounter < Settings::get_EventLimit())
            {
                m_EventCounter++;
            }
            else
            {                    
                //printf("Terminou evento de liga ou Fuga\n");
                if (m_Channel % 2 ==  1){ // Canais impares sao de diferencial
                    //m_tempo.stop();
                    tempofuga = (int) (Settings::get_EventLimit() * UMCICLO) + m_tempo.read_ms();
                    //printf("Limite %d\n", (int) (Settings::get_EventLimit() * UMCICLO));
                    m_tempo.reset();
                }
                else
                    tempofuga = 0;
                m_OutletTriggered = false;
                
                SendMessage(0, rmsvalue, mv2, under, over, tempofuga);
                //OnTrigger(buf, rmsvalue, mv2, under, over, tempofuga);//TODO: must change the parameter of this function call
                //printf("===> contliga %d contdesliga %d\n", contliga, contdesl);
                
                m_EventCounter = 0;
            }
        }
        else
            m_EventCounter = 0;
    }    
}
            
void EventDetector::ShowValues(CaptureEvent* e)
{   
    int i;
         
    printf("RFID: %s\n", e->get_RFID());
    printf("type: %d\n", e->get_Type());    
    printf("OutletNr: %d\n", e->get_OutletNumber());
    printf("MeanValue: %f\n", e->get_MeanValue());
    printf("MV2: %f\n", e->get_MV2());
    printf("RMSValue: %f\n", e->get_RMSValue());
    printf("Underflow: %d\n", e->get_Under());
    printf("Overflow: %d\n", e->get_Over());
    printf("Gain: %f\n", e->get_Gain());
    printf("Offset: %d\n", e->get_Offset());
    printf("Duration: %d\n", e->get_Duration());
    
    
    for(i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        printf("%d,",e->get_SampleValue(i));
    } 
    
}

void EventDetector::ExternalTrigger()
{
    // Ajustar valores de mv2, under, over e duration na chamada!!!
    SendMessage(1, 0, 0, 0, 0, 0);
}

//void EventDetector::SendMessage(int ext,float rmsvalue)
void EventDetector::SendMessage(int ext, float rmsvalue, float mv2, int under, int over, int duration)
{       
    int flagrfid = 0;
    short int buf[NUMBER_OF_SAMPLES];
    
    //printf("Chegou SendMessage\n");
    //Here we must alloc a CaptureEvent object from mailbox pool,
    
    //CaptureEvent* event;
    CaptureEvent* event = GetMailbox().alloc();
    
    
    //printf("Capturou evento\n");
    //then initialize the object properly
    
    /* O buffer foi coletado no ProcessEvent para retirada do VM
    unsigned short int buf[NUMBER_OF_SAMPLES];
    Capture::CopyBuffer(m_Channel,buf);
    */
    if(ext)
    {
        rmsvalue = 0;//SignalProcessor::CalculateRMS(buf,m_Channel);
    }
    
    float mv;    
        
    int type=0,outlet_number=0, aux=0;
    aux = Settings::get_OutletNumber(m_Channel);
    outlet_number = Settings::get_Outlet(aux);
    
    //Temporario - Sem leitor de RFID    
    //char rfid[9] = "1234560";
    //rfid[7] = (char)outlet_number + '0';
    
    // Com leitor de RFID
    char rfid[9], aux2[5];
    //rfid[0] = '\0';
    //send hitag request
    //capture hitag response
    //printf("OUTLET=%d\n",outlet_index+1);
        
   
    if (Settings::get_ReadRfid()){
        
        Capture::ReadRFID(outlet_number,rfid);
        
        if (strcmp(rfid, "00000000") != 0){ // get rfid number 
           //printf("Leu RFID [%s]\n", rfid);
           flagrfid = 1;
       }
    }
    if (! flagrfid){
        strcpy(rfid, "FFFF");
        sprintf(aux2, "%04d", outlet_number);
        strcat(rfid, aux2);
        //rfid[7] = (char)outlet_number + '0';        
    }
    //printf("#%s#\n", rfid);            
           
    if(Settings::get_Purpose(m_Channel) == 'p') // phase channel 
    {
        if(ext!=0)
            type = 3;
        else
        {
            if(m_OutletTriggered)
                type = 4;                           // power on event
            else
                type = 5;                           // power off event
        }
    }
    if(Settings::get_Purpose(m_Channel) == 'd') // diferential channel (leakage)
    {
        if(ext!=0)
            type = 2;
        else
        {
            if(m_OutletTriggered)
                type = 1;                           // start leakage event
            else
                type = 6;                           // stop leakage event
        }
    }
    
    if (type == 1)
        printf("Fuga na tomada %d com rms %f\n", outlet_number, rmsvalue);
        
    if (type == 4)
        printf("Liga na tomada %d com rms %f\n", outlet_number, rmsvalue);
    
    if (type == 5)
        printf("Desliga na tomada %d com rms %f\n", outlet_number, rmsvalue);
    
    if (type == 6)
        printf("Final de fuga na tomada %d com rms %f\n", outlet_number, rmsvalue);
    
    //event->Setup(rfid,type,outlet_number,mv,rmsvalue,Settings::get_Gain(m_Channel),Settings::get_Offset(m_Channel),seno,coss);
    
    //printf("Chegou montar evento\n");
    
    Capture::CopyBuffer( m_Channel, buf );
      
    event->Setup(rfid,type,outlet_number,mv,mv2, rmsvalue,under, over, Settings::get_Gain(m_Channel),Settings::get_Offset(m_Channel),duration, buf);
            
    //printf("\n\nDuration: %d\n\n", duration);
    //ShowValues(event);       
           
    //and finally place the object in the mailbox queue.
    GetMailbox().put(event);
    
    //printf("Deu put no evento no mailBox\n");
}

int EventDetector::TimeDelay(int t){    
    switch (t){
        case 0: return 300;
        case 1: return 250;
        case 2: return 200;
        case 3: return 250;
        case 4: return 200;
        default: return 150; 
    }
}
