#include <string>
#include <iostream>
#include <iomanip>
#include <mbed.h>
#include <math.h>
/**
 * Tests were done with schema proposed here: DS11195C-page 11 FIGURE 2-25: Potentiometer Divider Non-Linearity Error Test Circuit (DNL, INL)
 */
#include "MCP4xxxx_SPI.h"

struct UserChoice {
    char choice;
    unsigned char moduleId;
};

/*
 * Declare functions
 */
void AvailableIndicator(); // LED1 flashing for program while program is alive
UserChoice DisplayMenuAndGetChoice(); // Display and get the user choice

/*
 * Declare statics
 */

DigitalOut chipSelect[] = {p8,p9,p10};    // c -  MAIS SIGNIFICATIVO



CMCP4xxxx_SPI g_digitalPot(p5, p6, p7, NC, NC, NC); // Create an instance of the class CMCP4xxxx_SPI, p5/p6/p7: SPI#1, /CS managed by library, /RESET input not connected, , /SHDN input not connected

int main() {

    //unsigned int potLevel1 = 0x0; // Initial digital potentiometer value
    //unsigned int potLevel2 = 0x0; // Initial digital potentiometer value
    
    int value = 0;
    int num_pot = 0;

    while (true) 
    {
        do {
        
        printf("\r\nDigite o numero do potenciometro (1 a 8):");
        scanf("%d", &num_pot);
        }while(num_pot < 1 || num_pot > 12);
    
        do {
        
        printf("\r\nDigite o valor do volume (0 a 8):");
        scanf("%d", &value);
        }while(value < 0 || value >255);
        
        
           
        chipSelect[0].write(((num_pot-1) >> 2) & 0x1);
        chipSelect[1].write(((num_pot-1) >> 1) & 0x1);
        chipSelect[2].write(((num_pot-1) >> 0) & 0x1);
        
        int value2 = 256 - (pow((double)2,(double)value));
        printf("Value = %d", value2);
        
        g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot1, value2);
        
        
        
        chipSelect[0].write(1);
        chipSelect[1].write(1);
        chipSelect[2].write(1);
/*

        g_chipSelect1.write(0);
        
        g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot1, potLevel1);

        
        g_chipSelect1.write(1);
        
        
        g_chipSelect2.write(0);
        
        g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot1, potLevel2);

        
        g_chipSelect2.write(1);
        
        potLevel1+=1;
        potLevel2-=1;
        
        g_chipSelect2.write(0);        
        g_digitalPot.Write(CMCP4xxxx_SPI::WriteToPot1, potLevel2);
        g_chipSelect2.write(1);*/
    
    }

            
}


