#include "mbed.h"
#include "HMC5883L.h"
#define N        3

HMC5883L compass(p9, p10);
DigitalOut myled(LED1);

int main() 
{
    int get_mag[N]   =   {0};    // Buffer of the compass
    int    mag[N]       =   {0};
    compass.setDefault();
    wait(0.1);                        // Wait some time for all sensors (Need at least 5ms)
    
    while(1) 
    {
        myled = 1;
        wait(0.2);
        
        compass.readData(get_mag);
        for( int i=0;i<N;i++ ){     mag[i] = (int16_t)get_mag[i];   }
        
        printf("Compass = %d, %d, %d\r\n", mag[0], mag[1], mag[2]);
        myled = 0;
        wait(0.2);
    }
}
