#include "mbed.h"
 
Serial pc(USBTX,USBRX);

InterruptIn Pulso(D11);

DigitalOut LED(LED1);

DigitalIn botao(PC_13);

AnalogIn Sensor_Carga(A0);
AnalogIn Sensor_Pedal(A2);

DigitalOut T_Vela_1(D2);
DigitalOut T_Vela_2(D3);
DigitalOut T_Vela_3(D4);
DigitalOut T_Vela_4(D6);

DigitalOut T_Injecao_1(D7);
DigitalOut T_Injecao_2(D8);
DigitalOut T_Injecao_3(D9);
DigitalOut T_Injecao_4(D10);

Timeout Vela;
Timeout Injecao;

Timer t;
Timer inj;
float valor = 0.00000000;
float valor_old = 0.00000000;
int dentes = 0;
int dentes_old = 0;
int ciclo = 0;
float t_ciclo = 0.000;
float t_ciclo_inj = 0.000;
float avanco_em_graus = 0.000;
int avanco = 0;
int t_injecao = 0;
int trocou = 0;

float avanco_float = 0;
float freq = 0;
float carga = 0;
float pedal = 0;
float pedal_norm = 0;
float carga_norm = 0;

void desligainjecao() 
{
    T_Injecao_1 = 0;
    T_Injecao_2 = 0;
    T_Injecao_3 = 0;
    T_Injecao_4 = 0;
    //Injecao.detach();
}

void desligavela() 
{
    T_Vela_1 = 0;
    T_Vela_2 = 0;
    T_Vela_3 = 0;
    T_Vela_4 = 0;
}
 
void tickcount() 
{
    
    t.stop();
    valor_old = valor;
    valor = t.read();
    
    LED=!LED;
    //dentes_old=dentes;
    dentes = dentes+1;    
    //printf("dentes: %i \r\n", dentes);
    t.reset();
    t.start();
}
 
void main() 
{
    printf("Programa comecando\r\n"); 
    avanco_em_graus = 4;
    avanco = 0;    //30*avanco_em_graus/180;
    t_injecao = 1;

    Pulso.rise(&tickcount);  
    
    while(1) 
    {
        carga = Sensor_Carga.read();
        pedal = Sensor_Pedal.read();
        pedal_norm = pedal*73+5;
        carga_norm = carga*100;
        
        avanco_em_graus = 0.0024*freq + 0.7188*carga_norm - 0.42902*pedal_norm;
        //t_injecao = 0.001*freq + 0.005*carga_norm + 0.007*pedal_norm;
        //t_injecao=0.0001*(10*carga_norm+10*pedal_norm);
        
        avanco_float = avanco_em_graus*60/360;
        int avanco = avanco_float;
        
        if (botao == 0){
            printf("rpm: %f \r\n", freq );
            printf("carga: %f \r\n", carga_norm);
            printf("pedal: %f \r\n", pedal_norm);
            printf("avanco: %i \r\n", avanco);
            printf("avanco em graus: %f \r\n", avanco_em_graus);
            }
        
        if (dentes != dentes_old)
        {
            dentes_old=dentes;
            freq = 1/(valor);
            if (valor >= valor_old)
            {
                t_ciclo = 30*valor_old;
                t_ciclo_inj = 0.000001/valor_old;
            }
            if (valor_old > valor)
            {
                t_ciclo = 30*valor;
                t_ciclo_inj = 0.000001/valor;
            }
        
            if (valor > 1.5f*valor_old)
            {
                dentes = 0;
            }
            if (dentes ==61)
            {
                dentes = 0;
            }
            
        // IGNICAO    
            if ((dentes == 57-avanco) and (ciclo == 0))
            {
                T_Vela_1 = 1; 
                Vela.attach(&desligavela, 0.1f*t_ciclo); 
            }
        
            if ((dentes == 27-avanco) and (ciclo == 0))
            {
                T_Vela_2 = 1; 
                Vela.attach(&desligavela, 0.1f*t_ciclo);
                
                if (trocou == 0)
                {
                ciclo=1;
                trocou = 1;
                }
            }
        
            if ((dentes == 57-avanco) and (ciclo == 1))
            {
                T_Vela_3 = 1;
                Vela.attach(&desligavela, 0.1f*t_ciclo); 
            }
            
            if ((dentes == 27-avanco) and (ciclo == 1) and (trocou == 0))
            {
                T_Vela_4 = 1; 
                Vela.attach(&desligavela, 0.1f*t_ciclo); 
                
                if (trocou == 0)
                {
                    ciclo = 0;
                    trocou=1;
                }
            }
            
        // INJECAO
            if ((dentes == 26) and (ciclo == 0))
            {
                T_Injecao_1 = 1;
                //inj.start();
                Injecao.attach(&desligainjecao, t_ciclo_inj);
            }
        
            if ((dentes == 56) and (ciclo == 0))
            {
                T_Injecao_2 = 1;
                //inj.start();
                Injecao.attach(&desligainjecao, t_ciclo_inj);
            }
        
            if ((dentes == 26) and (ciclo == 1))
            {
                T_Injecao_3 = 1;
                //inj.start();
                Injecao.attach(&desligainjecao, t_ciclo_inj);
            }
            
            if ((dentes == 56) and (ciclo == 1))
            { 
                T_Injecao_4 = 1;
                //inj.start();
                Injecao.attach(&desligainjecao, t_ciclo_inj);
            }   
            
            trocou=0;
            
            /*if (inj.read() > t_injecao)
            {
                T_Injecao_1 = 0;
                T_Injecao_2 = 0;
                T_Injecao_3 = 0;
                T_Injecao_4 = 0;
                desligainjecao();
                inj.stop();
                inj.reset();
            }*/
        }
    }
}

