#define APP_VERSION     0.6f
#define MQTT_VERSION    3
#define BROKER_NAME     "broker.hivemq.com"
#define BROKER_PORT     1883

#include "debounce_button.h"
#include "EthernetInterface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

char* topic = "dansvloerVincent/votes";
volatile bool button1_pressed = false;   // Used in the main loop
volatile bool button1_enabled = true;   // Used for debouncing
volatile int multiclick_state = 0;   // Counts how many clicks occured in the time slot, used in main loop
volatile bool button1_busy = false;      // Informs the mainloop that the user is clicking the button

/**
    TODO
    ----
    -   Check if the button has been pressed. If so, print the amount of clicks to a serial terminal.
    -   Make an MQTT-service which:
        -   starts up a network using EthernetInterface. Make sure the development board requests its address via DHCP.
        -   makes a client and connects it to the broker using a client ID and credentials (username & password).
        -   sends messages at the same topic as the smartphone app from PGO 2. Feel free to choose which Quality of Service
            you are going to use. Make a separate function which handles the sending procedure. Therefore, this function
            can be called each time we want to send a certain message.
    -   When the button is pressed once, we send an upvote. When pressed twice, a downvote is sent. By pressing 4 times,
        the program disconnects from the broker and terminates.
        
    Extra
    -----
    -   Subscribe to the topic on which the song data is published. Display this received message on the serial terminal.
    -   Test this controller in the complete system of PGO 2. Use these controllers instead of the smartphones.
    
    Tips & tricks
    -------------
    -   To generate an interrupt on the press of a button, use:
            InterruptIn button(USER_BUTTON);
            ...
            button.fall(callback(someFunction));
    -   Before implementing MQTT, test the multiclick feature first.
    -   Have a look at the MQTT-library for Mbed and the HelloMQTT-example.
    -   To have a uniform message sending procedure, use the following function usage:
            sendMessage(&client, topic, buf, qos, retained, duplicate)
*/

int main(int argc, char* argv[])
{
    printf("Vote controller booting...\n");
    int rc;
    
    InterruptIn button(USER_BUTTON);
    button.fall(&button1_onpressed_cb);
    
    EthernetInterface eth;
    eth.connect();
    const char *ip = eth.get_ip_address();
    printf("IP address is: %s\n", ip ? ip : "No IP");
    
    NetworkInterface *net = &eth;
    MQTTNetwork mqtt( net );
    
    MQTT::Client<MQTTNetwork, Countdown> client( mqtt );
    
    char *host = "143.129.39.151";//"broker.mqttdashboard.com";
    int port = 1883;
    rc = mqtt.connect(host, port);
    if (rc != 0)
        printf("rc from TCP connect is %d\n", rc);
    
    
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = MQTT_VERSION;
    data.clientID.cstring = "VincentController";
    data.username.cstring = "smartcity";
    data.password.cstring = "smartcity";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\n", rc);
    
    MQTT::Message message;
    message.qos = MQTT::QOS1;
    printf("Start clicking\n");
    char buf[100];
    
    while( multiclick_state < 4 )
    {
        // Keep running
        
        
        if(!button1_busy && multiclick_state > 0)
        {
            //printf("%d\n", multiclick_state);
            if(multiclick_state == 1)
                sprintf(buf, "like\n");
            else
                //buf = "dislike\n";
                sprintf(buf, "dislike\n");
            multiclick_state = 0;
            
            printf("%s\n", buf);
            message.payload = (void *)buf;
            message.payloadlen = strlen(buf) + 1;
            client.publish(topic, message);
        }
        
        
        //printf("%d\n", multiclick_state);
    }
    
    
    
    if ((rc = client.disconnect()) != 0)
        printf("rc from disconnect was %d\n", rc);
    mqtt.disconnect();
    
    printf("Terminate...\n");

    return 0;
}
