#include "mbed.h"
#include "MMA8452.h"
#include <math.h>

Serial pc(USBTX, USBRX);
SPI spiTest(p5, p6, p7,p8);
MMA8452 acc(p9, p10, 100000);

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);

void calculateAngle();
void display(int number);

int main() {
   int number = 10;
   char c[50];
   int x  = 0,y = 0,z = 0;
   while(1) {
      sprintf(c,"%f", number);
      pc.printf("x:%c \r\n",c[0]);
      pc.printf("x:%s \r\n",c);
      //Code de la librairie
      //Sort les valeur en int
      //acc.readXYZCounts(&x,&y,&z); //<-- to use
      //sort les valeur en double (c'est l'accélération
      //acc.readXYZGravity(&x,&y,&z);
      //calculateAngle(x,y,z);
      wait(1);
      number--;
   }
}

void calculateAngle(int x,int y, int z){
    //double x, y, z;
    float val = 0.5 * 180.0 / 3.1416;
    double calcule = (1-2*((x*x+y*y)/(x*x+y*y+z*z)));
    //;
    /*x = -0.016;
    y = -0.877;
    z = 0.499;*/
    led1 = abs(x);
    led2 = abs(y);
    led3 = abs(z);
    //float amplitude =sqrt(x*x+y*y+z*z);
    //float crossProductVector = sqrt(x*x+y*y);
    //float t = -1*asin(crossProductVector/amplitude)*val; //was z before
    //float e = 0.5*acos(1-2*((pow(x,2)+pow(y,2))/((pow(x,2)+pow(y,2)+pow(z,2)))))*val;
    float e2 = acos(calcule)*val;
    pc.printf("x:%lf   y:%lf z:%lf\r\n",x,y,z);
    pc.printf("angle: %lf\r\n",e2);
}
//possibilité de changement du type de valeur en paramêtre
void display(int number){
    char c[6];
    //Explication de la fonction sprintf https://www.tutorialspoint.com/c_standard_library/c_function_sprintf.htm
    int test = sprintf(c,"%*.4Lf", number);
    //sprintf(c,"%ld", number);
    spiTest.write(0x76);
    pc.printf("c = %u\r\n", c[3] == '\0');
    pc.printf("test = %d\r\n", test);
    
    switch(test) {
       case 1:
          spiTest.write(0x7E);
          spiTest.write(c[0]);
          break;
       case 2:
          spiTest.write(0x7D|c[0]);
          spiTest.write(0x7E|c[1]);
          break;
        case 3:
          break;
    }
    
    int n = sizeof(c)/sizeof(c[0]);
    pc.printf("n = %i\r\n", n);
    //control pour le décimal
    spiTest.write(0x77);  // Decimal control command
    //valeur possible
    //0b00000001 = 1.234
    //0b00000010 = 12.34
    //0b00000100 = 123.4
    spiTest.write(0b00000001);
    /*for (int i=4; i>=0; i--){
        cs = 0;
        spiTest.write(c[i]);
        cs = 1;
    }*/
    /*spiTest.write(c);
    ;
    spiTest.write(c[0]);*/
}
/*


int main() {
    //https://developer.mbed.org/handbook/SerialPC
    //https://developer.mbed.org/handbook/mbed-NXP-LPC1768-Getting-Started
    //pc.printf("Echoes back to the screen anything you type\n");
    int nombre = 0;
    cs = 1;
    spiTest.frequency(250000);
    cs = 0;
    spiTest.write(0x81);
    //int t =  spiTest.write(nombre);
    //pc.printf("Nombre = %X\r\n", t);
    cs = 1;
    while(1) {
        //uart.printf("%c",pc.getc());
        wait(0.7);
        nombre++;
        display(nombre);
        pc.printf("Nombre = %X\r\n", nombre);
        if(nombre == 15){
            return(0);
        }
    }
}


/* Ignore cette partie c'Est le lab
int main() {
    //https://developer.mbed.org/handbook/SerialPC
    //https://developer.mbed.org/handbook/mbed-NXP-LPC1768-Getting-Started
    //pc.printf("Echoes back to the screen anything you type\n");
    int nombre = 2;
    cs = 1;
    //uart.printf("%d",nombre);
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    // spiTest.format(8,3);
    // spiTest.frequency(1000000);
    cs = 0;
 
    // Send 0x8f, the command to read the WHOAMI register
    int t =  spiTest.write(0x8F);
    pc.printf("WHOAMI register = %X\r\n", t);
 
    // Send a dummy byte to receive the contents of the WHOAMI register
    //int whoami = spiTest.write(0x00);
    //printf("WHOAMI register = 0x%X\n", whoami);
    cs = 1;
    while(1) {
        //uart.printf("%c",pc.getc());
        cs = 0;
 
        // Send 0x8f, the command to read the WHOAMI register
        pc.scanf("%d",&nombre);
        t = spiTest.write(nombre);
        pc.printf("WHOAMI register = %X\r\n", t);
        cs = 0;
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        //pc.putc(pc.getc());
    }
}
*/