#include "mbed.h"
#include "Xbee.h"

void resetXbee(Serial* xbee)
{
    const int frameLength = 16;
    char frame[frameLength];
    frame[0] = 0x7E; // Start delimiter
    frame[1] = 0x00; // Length (MSB)
    frame[2] = 0x04; // Length (LSB)
    frame[3] = 0x08; // AT Command
    frame[4] = 0x00; // Frame ID
    frame[5] = 'R';
    frame[6] = 'E';
    frame[7] = 0x60;

    if (xbee->writeable())
    {
        for (int i = 0; i < frameLength; i++)
        {
            xbee->putc(frame[i]);
        }
    }
}
