#include "mbed.h"
#include "Sensors.h"

// Capteurs
DigitalIn  button(p9);
I2C accelero(p28, p27);

// Fontion de lecture du bouton
void readButton(char* buffer)
{
    buffer[1] = button;
}

// Fonction de lecture de l'accéléromètre
void readAccelero(char* buffer)
{
    // Activation de l'accéléromètre
    char data[2] = {CTRL_REG, 0x01};
    accelero.write(ACC_ADDRESS, (char*) data, 2);
    
    // Lecture du registre de l'accélération en X
    char result[2];
    char reg[1] = {ACC_X_REG};
    accelero.write(ACC_ADDRESS, (char*) reg, 1, true);
    accelero.read(ACC_ADDRESS, (char*) result, 2);
    short accX = convertToAcceleration(result[0], result[1]);

    // Conversion des données sur 16 bits
    buffer[1] = accX & 0x00FF;
    buffer[2] = (accX & 0xFF00) >> 8;
}

// Fonction qui convertit la donnée retournée par l'accéléromètre en une valeur 16 bits
short convertToAcceleration(char hi, char lo)
{
    short value = (lo >> 2) | (hi << 6);
    if (value > UINT14_MAX/2)
    {
        value -= UINT14_MAX;
    }
 
    return value;
}
