#include "mbed.h"
#include "Sensors.h"
#include "Receiver.h"
#include "Xbee.h"

// FileSystem (pour lire fichier de config)
LocalFileSystem local("local");

// Entrées-sorties
DigitalOut reset(p8);
Serial xbee(p13, p14);
Serial pc(USBTX, USBRX);

// Paramètres du fichier de config
const int paramCount = 2;
Parameter params[paramCount];

// Tableau de fonctions pour la lecture des capteurs
const int sensorsCount = 2;
void (*readSensorsTable[sensorsCount]) (char*) = {&readButton, &readAccelero};

// Fonction de lecture du fichier de config
void readConfig()
{
    FILE *file = fopen("/local/receiver.cfg", "r");
    char* token;
    char* delimiter = "=";

    params[PAN_ID] = (Parameter) {.name = "PAN_ID", .base = 16};
    params[PERIOD] = (Parameter) {.name = "Period", .base = 10};

    if (file != NULL)
    {
        char line[128];
        
        // Lire ligne par ligne
        while (fgets(line, sizeof(line), file) != NULL)
        {
            // token = nom du paramètre
            token = strtok(line, delimiter);
            for (int i = 0; i < paramCount; i++)
            {
                if (strcmp(token, params[i].name) == 0)
                {
                    // configValue = valeur du paramètre
                    char* configValue = strtok(NULL, delimiter);
                    // conversion en entier 64 bit
                    params[i].value = strtoll(configValue, NULL, params[i].base);
                }
            }
        }
        
        fclose(file);
    }
}

// Fonction de lecture des capteurs
void readSensors(char sensorInfo[])
{
    char sensorId = sensorInfo[0];
    readSensorsTable[sensorId] (sensorInfo);
}

// Fonction pour combiner deux buffers en un
int mergeBuffers(char* buffer1, int size1, char* buffer2, int size2, char* result)
{
    memcpy(result, buffer1, size1);
    memcpy(result + size1, buffer2, size2);
    
    return size1 + size2;
}

// Fonction principale
int main()
{
    // Réinitialisation du Xbee
    reset = 0;
    wait(0.4);
    reset = 1;
    wait(1);

    // Vidage du buffer de lecture du Xbee
    while (xbee.readable())
    {
        char dump = xbee.getc();
    }

    // Lire la config et assigner le PAN ID
    readConfig();
    setPanId(&xbee, params[PAN_ID].value);

    // Buffers pour les données des capteurs
    char buttonBuffer[2];
    char acceleroBuffer[3];
    buttonBuffer[0] = 0;    // Numéro du capteur
    acceleroBuffer[0] = 1;  // Numéro du capteur

    while (true)
    {
        // Lire les capteurs
        readSensors(buttonBuffer);
        readSensors(acceleroBuffer);

        // Envoi des données au coordinateur
        char transmitBuffer[3];  // Taille du buffer est 2 + 1
        int size = mergeBuffers(buttonBuffer + 1, 1, acceleroBuffer + 1, 2, transmitBuffer);
        transmitRequest(&xbee, transmitBuffer, size);
        
        // Attente configurable
        wait_ms(params[PERIOD].value);
    }
}
