#include "mbed.h"
#include "Websocket.h"
#include "Xbee.h"
#include "EthernetInterface.h"
#include <string>

// Entrées-sorties
Serial xbee(p13, p14);
Serial pc(USBTX, USBRX);
DigitalOut reset(p8);

// FileSystem (pour lire fichier de config)
LocalFileSystem local("local");

// Fonction de lecture du fichier de config
void readConfig(unsigned long long* panID, string* url)
{    
    FILE *file = fopen("/local/coord.cfg", "r");
    char* token;
    char* delimiter = "=";

    if (file != NULL)
    {
        char line[128];
        
        // Lire ligne par ligne
        while (fgets(line, sizeof(line), file) != NULL)
        {
            // token = nom du paramètre
            token = strtok(line, delimiter);
            
            if (strcmp(token, "PAN_ID") == 0)
            {
                // token = valeur du paramètre
                token = strtok(NULL, delimiter);
                
                // conversion en entier 64 bit
                *panID = strtoull(token, NULL, 16);
            }
            else if(strcmp(token, "URL") == 0)
            {
                // token = valeur du paramètre
                token = strtok(NULL, delimiter);
                *url = token;
            }
        }
        
        fclose(file);
    }
}

// Fonction principale
int main()
{
    unsigned long long panID;
    string url;

    // Paramètres réseau statiques
    EthernetInterface eth;
    char* ip = "10.0.0.10";
    char* mask = "255.255.255.0";
    char* gateway = "10.0.0.1";
    eth.init(ip, mask, gateway);
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());

    // Reset du Xbee
    reset = 0;
    wait(0.4);
    reset = 1;
    wait(1);

    // Vidage du buffer de lecture du Xbee
    while (xbee.readable())
    {
        char dump = xbee.getc();
    }

    // Lire la config et assigner le PAN ID
    readConfig(&panID, &url);    
    setPanId(&xbee, panID);

    // Convertir l'URL du serveur Websockets de std::string à un char[]
    char* urlString = new char[url.size() + 1];
    std::copy(url.begin(), url.end(), urlString);
    urlString[url.size()] = '\0';

    // Connexion au serveur Websockets
    Websocket socket(urlString);
    socket.connect();

    while (true)
    {
        char bufferToSend[128];

        // Lecture des données reçues par le Xbee, si true -> un message complet a été reçu
        if (readPacket(&pc, &xbee, bufferToSend))
        {
            // Envoi au serveur
            socket.send(bufferToSend);
            pc.printf("Envoi de %s\r\n", bufferToSend);
        }
    }
}
