#include "mbed.h"
#include "rtos.h"
#include "XBeeLib.h"
 
using namespace XBeeLib;
 
Serial pc(USBTX, USBRX);
 
XBeeZB* xbee;

DigitalIn capteur_1(p23);
DigitalIn capteur_2(p24);
DigitalIn capteur_3(p25);
DigitalIn capteur_4(p26);
DigitalIn capteur_5(p27);
DigitalIn capteur_6(p28);
 
Mutex capt_lock;
 
bool capt_1;
bool capt_2;
bool capt_3;
bool capt_4;
bool capt_5;
bool capt_6;
 
/* lecture des capteurs à partir des broches du mbed : p15, p16, p17, 19, 20 21*/
 
void lecture_capteurs (void const *args){
    capt_lock.lock();
    
    capt_1=capteur_1.read();
    capt_2=capteur_2.read();
    capt_3=capteur_3.read();
    capt_4=capteur_4.read();
    capt_5=capteur_5.read();
    capt_6=capteur_6.read();
    
    capt_lock.unlock();
}
 
void send_data_to_coordinator(const uint8_t* data)
{ 
    const TxStatus txStatus = xbee->send_data_to_coordinator(data, 1);
}
 
void envoi_donnees (void const *args) {
    capt_lock.lock();
    uint8_t data[1];
    data[0] = (capt_1 << 7) | (capt_2 << 6) | (capt_3 << 5) | (capt_4 << 4) | (capt_5 << 3) | (capt_6 << 2);

    capt_lock.unlock();

    send_data_to_coordinator(data);
} 
 
int main (void) {
    xbee = new XBeeZB(p13, p14, NC, NC, NC, 9600);
    
    RtosTimer readTimer(lecture_capteurs, osTimerPeriodic);
    RtosTimer sendTimer(envoi_donnees, osTimerPeriodic);
    
    readTimer.start(10);
    sendTimer.start(10);
    
    wait(osWaitForever);
}
            