// Vincent Bélanger et Laurent Mandrile
// belv1802 - manl2003

#include "Frame.h"
#include "CRC16.h"

#pragma once

// Fonction de construction de trame
bitset<FRAMESIZE> buildFrame(bitset<MAX_DATA> data, char size)
{
    bitset<FRAMESIZE> bitset;
    
    // Preambule 01010101
    bitset.set(0, 0);
    bitset.set(1, 1);
    bitset.set(2, 0);
    bitset.set(3, 1);
    bitset.set(4, 0);
    bitset.set(5, 1);
    bitset.set(6, 0);
    bitset.set(7, 1);

    // Start 01111110
    bitset.set(8,  0);
    bitset.set(9,  1);
    bitset.set(10, 1);
    bitset.set(11, 1);
    bitset.set(12, 1);
    bitset.set(13, 1);
    bitset.set(14, 1);
    bitset.set(15, 0);
    
    // 8 bits non utilisés
    
    // Longueur
    bitset.set(24, size & 0b10000000);
    bitset.set(25, size & 0b01000000);
    bitset.set(26, size & 0b00100000);
    bitset.set(27, size & 0b00010000);
    bitset.set(28, size & 0b00001000);
    bitset.set(29, size & 0b00000100);
    bitset.set(30, size & 0b00000010);
    bitset.set(31, size & 0b00000001);

    // Insertion des données utiles
    char payload[size];
    for (int i = 0; i < size * 8; i++)
    {
        bitset.set(32 + i, data[i]);

        if ((i % 8) == 0)
        {
            // Conversion en octets pour le calcul du CRC16
            payload[i / 8] = (data[i] << 7) | (data[i + 1] << 6) | (data[i + 2] << 5) | (data[i + 3] << 4) | (data[i + 4] << 3) | (data[i + 5] << 2) | (data[i + 6] << 1) | (data[i + 7] << 0);
        }
    }

    // Calcul du CRC16
    unsigned short crc = CRC16::calculateCRC16(payload, size);
    int counter = 32 + size*8;

    // Ajout du CRC
    bitset.set(counter,    crc & 0b1000000000000000);
    bitset.set(counter+1,  crc & 0b0100000000000000);
    bitset.set(counter+2,  crc & 0b0010000000000000);
    bitset.set(counter+3,  crc & 0b0001000000000000);
    bitset.set(counter+4,  crc & 0b0000100000000000);
    bitset.set(counter+5,  crc & 0b0000010000000000);
    bitset.set(counter+6,  crc & 0b0000001000000000);
    bitset.set(counter+7,  crc & 0b0000000100000000);
    bitset.set(counter+8,  crc & 0b0000000010000000);
    bitset.set(counter+9,  crc & 0b0000000001000000);
    bitset.set(counter+10, crc & 0b0000000000100000);
    bitset.set(counter+11, crc & 0b0000000000010000);
    bitset.set(counter+12, crc & 0b0000000000001000);
    bitset.set(counter+13, crc & 0b0000000000000100);
    bitset.set(counter+14, crc & 0b0000000000000010);
    bitset.set(counter+15, crc & 0b0000000000000001);
    
    // End
    bitset.set(counter+16, 0);
    bitset.set(counter+17, 1);
    bitset.set(counter+18, 1);
    bitset.set(counter+19, 1);
    bitset.set(counter+20, 1);
    bitset.set(counter+21, 1);
    bitset.set(counter+22, 1);
    bitset.set(counter+23, 0);

    return bitset.flip();
}

// Fonction de conversion d'octets en bits
bitset<MAX_DATA> convertToBits(char* message, char size)
{
    bitset<MAX_DATA> bitset;

    for (int i = 0; i < size; i++)
    {
        bitset.set(8*i,   message[i] & 0b10000000);
        bitset.set(8*i+1, message[i] & 0b01000000);
        bitset.set(8*i+2, message[i] & 0b00100000);
        bitset.set(8*i+3, message[i] & 0b00010000);
        bitset.set(8*i+4, message[i] & 0b00001000);
        bitset.set(8*i+5, message[i] & 0b00000100);
        bitset.set(8*i+6, message[i] & 0b00000010);
        bitset.set(8*i+7, message[i] & 0b00000001);
    }

    return bitset;
}
