// Vincent Bélanger et Laurent Mandrile
// belv1802 - manl2003

#include "mbed.h"
#include "LPC17xx.h"
#include <bitset>

#pragma once

#define CLOCKS_TO_SECOND 96000000
#define FRAMESIZE 696
#define MAX_DATA 640
#define DEBUG 0

using namespace std;

// Enumération des états de la MEF
enum STATES
{
    PREAMBLE,
    START,
    TYPE,
    LENGTH,
    DATA,
    CRC16STATE,
    END,
    NOSTATE  
};

void debugPrint();
void initTimers();
extern void _decodeCallback(bitset<MAX_DATA> decMessage, int size);
extern void _decodeError();
extern void _updateState(STATES state);
