#include "mbed.h"
#include "FirmwareUpdater.h"
#include "EthernetNetIf.h"
 
EthernetNetIf eth;
FirmwareUpdater fwup("http://mbed.org/media/uploads/vinajarr/", "firm2", true); 
 
DigitalOut myled(LED1);  // LED Rojo PB22   

 
// There are 2 files for the firmware.
//  1. firm.txt : firmware version file.
//  2. firm.bin : firmware binary file.
 
void check_newfirm() {
    if (fwup.exist() == 0) {
        printf("Found a new firmware.\n");
        if (fwup.execute() == 0) {
            printf("Update succeed.\n");
            printf("Resetting this system...\n\n\n\n\n");
            fwup.reset();
        } else {
            printf("Update failed!\n");
        }
    }
    else{
    printf("Not found a new firmware.\n");   
    printf("actual version: %d \n",fwup.get_); 
    }
}
 
int main(void) {
  
    eth.setup();
 
 while(1){
 
    check_newfirm();
    
    // Your application is here.   

        myled = 1;
        wait(0.1);
        myled = 0;
        wait(0.2);

    }

    
    
}