#include "mbed.h"
#include "SDFileSystem.h"
Serial pc(USBTX, USBRX); // Primary output to demonstrate library

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
FILE *fp;

#include "FXOS8700CQ.h"
#include "MMA8451Q.h"
#include "LSM303D.h"
#include "MPU6050.h"
#include "ADXL335.h"

#define SDA  PTE25
#define SCL  PTE24

#define MMA8451_I2C_ADDRESS (0x1c<<1)


#define DATA_RECORD_TIME_MS 1000
uint32_t do_list(const char *fsrc);

I2C i2c(SDA, SCL);

//objetos de los acelerometros
MMA8451Q mma(&i2c, MMA8451_I2C_ADDRESS);
LSM303D lsm(&i2c);
ADXL335 adx(PTB2,PTB3,PTB10);
MPU6050 mpu(&i2c); 
FXOS8700CQ fxos(&i2c, FXOS8700CQ_SLAVE_ADDR1); // SDA, SCL, (addr << 1)

DigitalOut green(LED_GREEN); // waiting light
DigitalOut blue(LED_BLUE); // collection-in-progress light
DigitalOut red(LED_RED); // completed/error ligt

Timer t; // Microsecond timer, 32 bit int, maximum count of ~30 minutes
InterruptIn fxos_int2(PTC13); // should just be the Data-Ready interrupt
InterruptIn sw3_int(PTA4); // switch SW3
InterruptIn sw2_int(PTC6); // switch SW2
InterruptIn mpu_int(PTC3);// should just be the Data-Ready interrupt
InterruptIn mma_int1(PTD1);// should just be the Data-Ready interrupt
InterruptIn lsm_int1(PTA2); // should just be the Data-Ready interrupt

// Interrupt status flags and data

bool fxos_int2_triggered = false;
bool mpu_int_triggered = false;
bool mma_int1_triggered = false;
bool lsm_int1_triggered = false;
uint32_t us_ellapsed = 0, beforePrint = 0;
bool sw2_push = false;
bool sw3_push = false;

// Storage for the data from the sensor
SRAWDATA acc[5];



volatile SRAWDATA ac;
const uint16_t size = 400;
volatile float accT[size][2];
volatile uint32_t tiempo[size][2];
volatile uint32_t puntero[2] = {0,0};
bool escribirSD = false;

void fxos_int2_interrupt(void)
{
    fxos_int2_triggered = true;
    //fxos.get_dataAcc(&acc[0]);
}

void mpu_int_interrupt (void)
{
    mpu_int_triggered = true;
}

void mma_int1_interrupt (void)
{
    mma_int1_triggered = true;
    
    ac.x=mma.getAccX();
    ac.y=mma.getAccY();
    ac.z=mma.getAccZ();
    
    accT[puntero[0]][puntero[1]]=sqrt(ac.x*ac.x+ac.y*ac.y+ac.z*ac.z);
    tiempo[puntero[0]][puntero[1]]=t.read_us();  
    puntero[0]++;
    if(puntero[0]>(size-1)){
        puntero[0]=0;
        puntero[1] = (puntero[1] + 1) % 2;
        escribirSD=true;
    } 
}

void lsm_int1_interrupt (void)
{
    lsm_int1_triggered = true;
}

void SW3_interrupt(void)
{
    sw3_push=true;
}

void print_cabecera(){
    pc.printf("T\t");
    pc.printf("Va\t\t");
    /*for(int i=1;i<5;i++){
        pc.printf("Z%d\t\t",i);
    }*/
    pc.printf("\r\n");
}
    
void print_data(){
    //us_ellapsed= t.read_us()-beforePrint;
    pc.printf("%d\t",t.read_us());
    pc.printf("%.5f\t", accT);
    /*for(int i=0;i<5;i++){
        if(i!=7){
        pc.printf("%+.3f\t", acc[i].z);
       // pc.printf("%+.4f\t%+.4f\t%+.4f\t", acc[i].x, acc[i].y, acc[i].z);
       }
    }*/
    pc.printf("\r\n");
    //beforePrint=t.read_us();
    }

void print_reading()
{
    us_ellapsed= t.read_us()-beforePrint;
    beforePrint=t.read_us();
    pc.printf("%d ",us_ellapsed);
    for(int i=1;i<5;i++){
    pc.printf("A[%d] X:%+.3f,Y:%+.3f,Z:%+.3f\t",
              i,
              acc[i].x, acc[i].y, acc[i].z
              );
    }
    pc.printf("\r\n");
}

void readAcc()
{
   uint64_t int_time = t.read_us();
    
   //acelerometro 0
    /*
    while(!fxos_int2_triggered && t.read_us()-int_time < 4000 && fxos_int2.read()){wait_us(1);}
    fxos_int2_triggered = false; // un-trigger
    fxos.get_dataAcc(&acc[0]); // clear interrupt from device
    
    if(t.read_us()-int_time>4000) pc.printf("Error lectura Fxos ");
    */
    int_time = t.read_us();
    while(!mma_int1_triggered && t.read_us()-int_time<4000 && mma_int1.read()){}
    mma_int1_triggered = false; // un-trigger
    //acelerometro 1
    /*acc[1].x=mma.getAccX();
    acc[1].y=mma.getAccY();
    acc[1].z=mma.getAccZ();*/
    
    //accT=sqrt(ac.x*ac.x+ac.y*ac.y+ac.z*ac.z);
    
    if(t.read_us()-int_time>4000) pc.printf("Error lectura mma \t\t");
    
    /*
    int_time = t.read_us();
    while(!mpu_int_triggered && t.read_us()-int_time<4000 && mpu_int.read()){wait_us(1);}
    mpu_int_triggered = false; // un-trigger
    //acelerometro 2
    float xyz[3];
    mpu.getAccelero( xyz );
    mpu.read(0x3A);
    acc[2].x = xyz[0];
    acc[2].y = xyz[1];
    acc[2].z = xyz[2];
    
    
    if(t.read_us()-int_time>4000) pc.printf("Error lectura mpu ");

    int_time = t.read_us();
    while(!lsm_int1_triggered && t.read_us()-int_time<4000 && !lsm_int1.read()){ wait_us(1);}
    lsm_int1_triggered = false; // un-trigger
    //acelerometro 3
    lsm.readA(&acc[3].x,&acc[3].y,&acc[3].z); 
    
    if(t.read_us()-int_time>4000) pc.printf("Error lectura lsm ");
    
    //acclerometro 4
    adx.getAcc(acc[4]);
    */
}

void    initFxox(){
    // Diagnostic printing of the FXOS WHOAMI register value
    pc.printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", fxos.get_whoami());
    fxos.enable();
    
    fxos_int2.mode(PullUp);
    wait_ms(20);
    fxos_int2.fall(&fxos_int2_interrupt);
    
    /*for(int i=0;i<0x7A;i++){
        uint8_t data =0;
        fxos.read_regs(i,&data,1);
        pc.printf("0x%x:\t0x%x\r\n",i,data);
    }*/
    
    while(fxos_int2.read()==0){
        uint8_t data =0;
        fxos.get_dataAcc(&acc[0]);
        fxos.read_regs(0x00,&data,1);
        pc.printf("0x%x:\t0x%x\r\n",0x00,data);
    }
    
    

    while(!fxos_int2_triggered){ wait_ms(1); }
    
    fxos_int2_triggered = false; // un-trigger
    fxos.get_dataAcc(&acc[0]);
    // clear interrupt from device
    pc.printf(" A[0] X:%+.4f,Y:%+.4f,Z:%+.4f\n\r", 
        acc[0].x, acc[0].y, acc[0].z);
    }
    
void    initMma(){
    
    pc.printf("MMA8451 ID: %d\n", mma.getWhoAmI());
    
    /*for(int i=0;i<0x32;i++){
        uint8_t data =0;
        mma.readRegs(i,&data,1);
        pc.printf("0x%x:\t0x%x\r\n",i,data);
    }*/
    
    mma_int1.mode(PullUp); 
    wait_ms(20);
    mma_int1.fall(&mma_int1_interrupt);
    
    while(mma_int1.read()==0){
        ac.x=mma.getAccX();
        ac.y=mma.getAccY();
        ac.z=mma.getAccZ();
    }

    
    
    while(!mma_int1_triggered){  wait_ms(1); }
    
    mma_int1_triggered = false; // un-trigger
    pc.printf(" A[1] X:%+.4f,Y:%+.4f,Z:%+.4f\r\n",
    mma.getAccX(), mma.getAccY(), mma.getAccZ() );
    
    }
    
void    initMpu(){
    float acc[3];
    
    mpu.setAcceleroRange(MPU6050_ACCELERO_RANGE_2G);
    pc.printf("MPU6050 testConnection \r\n");
    
    /*for(int i=0xD;i<0x76;i++)
    {
        pc.printf("Ox%x: 0x%x\r\n",i,mpu.read(i));
    }*/
    
    mpu_int.mode(PullUp);
    wait_ms(20);
    mpu_int.fall(&mpu_int_interrupt);
    
    while(mpu_int.read()==0){
        mpu.getAccelero( acc );
        pc.printf("Ox%x: 0x%x\r\n",0x3A,mpu.read(0x3A));
    }
    
    while(!mpu_int_triggered){ wait_ms(1);} //wait interrupt
    mpu_int_triggered = false; // un-trigger
    
    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("\r\nMPU6050 test passed\r\n");
    } else {
        pc.printf("\r\nMPU6050 test failed \r\n");
    }
    
    pc.printf(" A[2] temp:%+.4f", mpu.getTemp());
    mpu.getAccelero( acc );
    pc.printf(" X:%+.4f,Y:%+.4f,Z:%+.4f\r\n",acc[0], ac,acc[2]);   
    pc.printf("Ox%x: 0x%x\r\n",0x3A,mpu.read(0x3A));  
}

void    initLsm(){
    double acc[3];
    char reg_v=0;
    pc.printf("LSM303D comprobacion de configuracion: \r\n");
    for(int i=0;i<0x3E;i++)
    {
        if(lsm.read_reg(addr_acc_mag,i,&reg_v)){ 
            pc.printf("Ox%x: 0x%x\r\n",i,reg_v);
        }
    } 
    
    
    lsm.readA(&acc[0],&acc[1],&acc[2]);
    lsm.readA(&acc[0],&acc[1],&acc[2]);
    
    lsm.read(&acc[0],&acc[1],&acc[2],&acc[0],&acc[1],&acc[2]);
    lsm.read(&acc[0],&acc[1],&acc[2],&acc[0],&acc[1],&acc[2]);
    lsm.read(&acc[0],&acc[1],&acc[2],&acc[0],&acc[1],&acc[2]);
    lsm.read(&acc[0],&acc[1],&acc[2],&acc[0],&acc[1],&acc[2]);
    
    for(int i=0;i<0x3E;i++)
    {
        if(lsm.read_reg(addr_acc_mag,i,&reg_v)){ 
            pc.printf("Ox%x: 0x%x\r\n",i,reg_v);
        }
    } 
    
    lsm_int1.mode(PullUp);
    wait_ms(20);
    lsm_int1.rise(&lsm_int1_interrupt);
    
    while(lsm_int1.read()==1){
        lsm.readA(&acc[0],&acc[1],&acc[2]);
        /*if(lsm.read_reg(addr_acc_mag,0x27,&reg_v)){ //registro de status_A
            pc.printf("Ox%x: 0x%x\r\n",0x27,reg_v);
        }*/
    }
    
    while(!lsm_int1_triggered){  wait_ms(1);}
    lsm_int1_triggered = false; // un-trigger
    
       
    if (lsm.readA(&acc[0],&acc[1],&acc[2])){
        pc.printf(" A[3] X:%+.4f,Y:%+.4f,Z:%+.4f\r\n",
              acc[2], acc[1],acc[2]);    
        }
    else{
        pc.printf(" LSM303D don't work ");
        } 
}






int main(void)
{
    //inicializacion basico
    t.reset();
    pc.baud(250000);
    sw3_int.mode(PullUp);
    sw3_int.fall(&SW3_interrupt);
    sw2_int.mode(PullUp);
    
    i2c.frequency(200000); //Configure speed I2C 200kHz
    
    // Lights off (FRDM-K64F has active-low LEDs)
    green.write(1);
    red.write(1);
    blue.write(1);
   /* 
    //inicializacion Acelerometros
    //initFxox();
    initMma();
    //initMpu();
    //initLsm();

    readAcc();
    print_reading();
    */
    green.write(0);
    red.write(1);
    blue.write(1);
    
    //esperar a pulsador
    while(!sw3_push){
        wait_ms(50);
        }
     
    pc.printf("Iniciando lectura de acelerometros\r\n");
    t.start();
    initMma();
    green.write(1);
    red.write(1);
    blue.write(0); 
        
    //Escribir en la SD      
    mkdir("/sd/data", 0777);
    uint32_t number = do_list("/sd/data");
    char archivo[50];
    snprintf(archivo,50,"/sd/data/%06ld.xls",number);
    fp = fopen(archivo, "w");
    if (fp == NULL) {
        pc.printf("Unable to write the file \n");
        while(1){wait(1);}
    }
    fprintf(fp,"T\tVa\r\n");
    while(1)
    {
        if(escribirSD)
        {
            uint8_t j = puntero[1]==0?1:0;
            for(uint32_t i=0; i<size;i++)
            {
                fprintf(fp,"%d\t %.5f\r\n",tiempo[i][j],accT[i][j]);
            }
            escribirSD = false;   
        }        
        if(sw2_int.read()==0){
            mma_int1.disable_irq ();
            
            for(uint32_t i=0; i<puntero[0];i++)
            {
                fprintf(fp,"%d\t %.5f\r\n",tiempo[i][puntero[1]],accT[i][puntero[1]]);
            }
            break;
        }
    }
    
    pc.printf("fin escritura \r\n");
    fclose(fp);
    
    fp = fopen(archivo, "r");
    if (fp == NULL) {
        pc.printf("Unable to open the file \n");
        while(1){wait(1);}
    }
    DigitalIn enSerial(D8);
    enSerial.mode(PullUp);
    if(enSerial.read()==1){
        while (1) {                  // print data por serial
            char ch = fgetc(fp);       // until src EOF read.
            if (ch == EOF || ch == 0xFF) break;
            pc.printf("%c",ch);
        }
    }
    
    green.write(1);
    red.write(0);
    blue.write(1);
    
    while (1) {}
    
       
       
        
        
    /*
    
    //lectura de todos los accelerometros
    
    print_cabecera();
    
    while(1){
    readAcc();
    print_data();
        if(sw2_int.read()==0) break;
    }
    
    
    
    
    */
}


  
    
    uint32_t do_list(const char *fsrc)
{
    DIR *d = opendir(fsrc);
    struct dirent *p;
    uint32_t counter = 0;
 
    while ((p = readdir(d)) != NULL) {
        counter++;
        printf("%s\n", p->d_name);
    }
    closedir(d);
    return counter;
}
