/****************************************************************************/
/*  Vision Industrielle IHM                                                 */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Library - Vision_Indus_IHM.h file                                       */
/****************************************************************************/
/*  Tested on DISCO-F746 / 14th nov 2021                                    */
/****************************************************************************/

#include "F746_GUI.hpp"
#include "mbed.h"

// Color ARGB (8-8-8-8)
#define     COLOR_OFF           0xFF666666
#define     CONV_PER_MIN_US     2000
#define     CONV_DIR_FW         1
#define     CONV_DIR_RV         0


/* Inputs and Outputs */
// Flex
extern      DigitalOut      flex1_out;
extern      DigitalOut      flex2_out;
// Dome
extern      DigitalOut      dome_out;
// Rasant
extern      DigitalOut      rasant_out;
// Effi-RGB
extern      DigitalOut      ringRGB_R_out;
extern      DigitalOut      ringRGB_G_out;
extern      DigitalOut      ringRGB_B_out;
// Conveyor

/* Graphical objects */
extern      Label       title;
extern      Label       subtitle;
// All On-Off
extern      Button      light_on;
extern      Button      light_off;
extern      uint8_t     all_on_active;
// EFFI-Ring
extern      Label       roundRGB;
extern      Button      roundRGB_R;
extern      Button      roundRGB_G;
extern      Button      roundRGB_B;
extern      uint8_t     roundRGB_R_active;
extern      uint8_t     roundRGB_G_active;
extern      uint8_t     roundRGB_B_active;
// EFFI-Dome
extern      Label       dome;
extern      Button      dome_W;
extern      uint8_t     dome_active;
// EFFI-Dome
extern      Label       rasant;
extern      Button      rasant_R;
extern      uint8_t     rasant_active;
// EFFI-Flex
extern      Label       flex1;
extern      Button      flex1_W;
extern      uint8_t     flex1_active;
extern      Button      flex2_W;
extern      uint8_t     flex2_active;
// Conveyor
extern      Label               conveyor;
extern      NumericLabel<int>   conv_speed_lab;
extern      SeekBar             conv_speed;


/* Functions */
/* initIHM */
void initIHM(void);
/* updateIHM */
void updateIHM(void);
/* updateIHM */
void moveConveyor(char dir, int speed_us);
/* updateIHM */
void stopConveyor(void);