/****************************************************************************/
/*  Vision Industrielle IHM                                                 */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Library - Vision_Indus_IHM.cpp file                                     */
/****************************************************************************/
/*  Tested on DISCO-F746 / 14th nov 2021                                    */
/****************************************************************************/

#include "Vision_Indus_IHM.h"

/* Inputs and Outputs */
// Flex
DigitalOut      flex1_out(D4);
DigitalOut      flex2_out(D5);
// Dome
DigitalOut      dome_out(D11);
// Rasant
DigitalOut      rasant_out(D12);
// Effi-RGB
DigitalOut      ringRGB_R_out(D6);
DigitalOut      ringRGB_G_out(D7);
DigitalOut      ringRGB_B_out(D8);
// Conveyor
PwmOut          conveyor_speed(D14);
DigitalOut      conveyor_dir(D15);
DigitalOut      conveyor_m0(D9);
DigitalOut      conveyor_m1(D10);
DigitalOut      conveyor_enable(D3);
DigitalOut      conveyor_reset(D13);
DigitalIn       conveyor_fault(D2);


/* Graphical objects */
Label       title(240, 2, "Vision Industrielle", Label::CENTER, Font24);
Label       subtitle(240, 25, "LEnsE / 2021", Label::CENTER, Font16);
// All On-Off
Button      light_on(250, 65, 80, 40, "ALL ON");
Button      light_off(340, 65, 80, 40, "ALL OFF");
uint8_t     all_on_active;
// EFFI-Ring
Label       ringRGB(10, 50, "EFFI-Ring RGB", Label::LEFT);
Button      ringRGB_R(10, 65, 50, 40, "RED");
Button      ringRGB_G(70, 65, 50, 40, "GREEN");
Button      ringRGB_B(130, 65, 50, 40, "BLUE");
uint8_t     ringRGB_R_active;
uint8_t     ringRGB_G_active;
uint8_t     ringRGB_B_active;
// EFFI-Dome
Label       dome(10, 115, "EFFI-Dome W", Label::LEFT);
Button      dome_W(10, 130, 80, 40, "Dome");
uint8_t     dome_active;
// EFFI-Dome
Label       rasant(100, 115, "EFFI-Rlla R", Label::LEFT);
Button      rasant_R(100, 130, 80, 40, "Rasant");
uint8_t     rasant_active;
// EFFI-Flex
Label       flex1(10, 180, "EFFI-Flex W", Label::LEFT);
Button      flex1_W(10, 195, 80, 40, "Flex1");
uint8_t     flex1_active;
Button      flex2_W(100, 195, 80, 40, "Flex2");
uint8_t     flex2_active;
// Conveyor
Label               conveyor(250, 200, "Convoyeur / Vitesse", Label::LEFT);
NumericLabel<int>   conv_speed_lab(400, 200, "V = ", Label::LEFT);
SeekBar             conv_speed(250, 250, 150, 0, 100, 0, "0", "", "100%");




/* initIHM */
void initIHM(void){
    all_on_active = 0;            
    light_off.Draw(0xFFFFFFFF, 0xFF000000);
    light_on.Draw(COLOR_OFF, 0xFFFFFFFF);
    /* EFFI-Ring */
    ringRGB_R_active = 0;
    ringRGB_R_out = 1;
    ringRGB_R.Draw(COLOR_OFF);
    ringRGB_G_active = 0;
    ringRGB_G_out = 1;
    ringRGB_G.Draw(COLOR_OFF);
    ringRGB_B_active = 0;
    ringRGB_B_out = 1;
    ringRGB_B.Draw(COLOR_OFF);
    /* EFFI-Dome */
    dome_active = 0;
    dome_out = 1;
    dome_W.Draw(COLOR_OFF);
    /* EFFI-Rlla */
    rasant_active = 0;
    rasant_out = 1;
    rasant_R.Draw(COLOR_OFF);
    /* EFFI-Flex */
    flex1_active = 0;
    flex1_out = 1;
    flex1_W.Draw(COLOR_OFF);
    flex2_active = 0;
    flex2_out = 1;
    flex2_W.Draw(COLOR_OFF);
    /* Conveyor */
    int8_t x = (int8_t)conv_speed.GetValue();
    conv_speed_lab.Draw("%3d m/s", x);   
    conveyor_enable = 1;
    conveyor_reset = 1;
    conveyor_m0 = 0;
    conveyor_m1 = 0;
    conveyor_speed.period_us(1000);
    conveyor_dir = CONV_DIR_FW;
    conveyor_speed.write(0);      // STOP    
}    

/* updateIHM */
void updateIHM(void){
    if (light_on.Touched()){
        all_on_active = 1;
    }
    if(all_on_active == 1){
        light_off.Draw(COLOR_OFF, 0xFFFFFFFF);
        light_on.Draw(0xFFFFFFFF, 0xFF000000);

        ringRGB_R_active = 1;
        ringRGB_R_out = 0;
        ringRGB_R.Draw(0xFFFF0000);
        ringRGB_G_active = 1;
        ringRGB_G_out = 0;
        ringRGB_G.Draw(0xFF33DD33, 0xFF000000);
        ringRGB_B_active = 1;
        ringRGB_B_out = 0;
        ringRGB_B.Draw(0xFF0000FF);
        
        dome_active = 1;
        dome_out = 0;
        dome_W.Draw(0xFFFFFFFF, 0xFF000000);
        
        rasant_active = 1;
        rasant_out = 0;
        rasant_R.Draw(0xFFFF0000);

        flex1_active = 1;
        flex1_out = 0;
        flex1_W.Draw(0xFFEEEEEE, 0xFF000000);
        flex2_active = 1;
        flex2_out = 0;
        flex2_W.Draw(0xFFEEEEEE, 0xFF000000);
                              
        all_on_active = 0;
    }
    else{
        light_off.Draw(0xFFFFFFFF, 0xFF000000);
        light_on.Draw(COLOR_OFF, 0xFFFFFFFF);
        if (light_off.Touched()){
            all_on_active = 0;
            light_off.Draw(0xFFFFFFFF, 0xFF000000);
            light_on.Draw(COLOR_OFF, 0xFFFFFFFF);
        }  
        if (ringRGB_R.Touched()){
            if(ringRGB_R_active){
                ringRGB_R_active = 0;
                ringRGB_R_out = 1;
                all_on_active = 0;
                ringRGB_R.Draw(COLOR_OFF);
            }
            else{
                ringRGB_R_active = 1;
                ringRGB_R_out = 0;
                ringRGB_R.Draw(0xFFFF0000);
            }
            
        }
        if (ringRGB_G.Touched()){
            if(ringRGB_G_active){
                ringRGB_G_active = 0;
                ringRGB_G_out = 1;
                all_on_active = 0;
                ringRGB_G.Draw(COLOR_OFF, 0xFFFFFFFF);
            }
            else{
                ringRGB_G_active = 1;
                ringRGB_G_out = 0;
                ringRGB_G.Draw(0xFF33DD33, 0xFF000000);
            }
            
        }
        if (ringRGB_B.Touched()){
            if(ringRGB_B_active){
                ringRGB_B_active = 0;
                ringRGB_B_out = 1;
                all_on_active = 0;
                ringRGB_B.Draw(COLOR_OFF);
            }
            else{
                ringRGB_B_active = 1;
                ringRGB_B_out = 0;
                ringRGB_B.Draw(0xFF0000FF);
            }
            
        }
        if (dome_W.Touched()){
            if(dome_active){
                dome_active = 0;
                dome_out = 1;
                all_on_active = 0;
                dome_W.Draw(COLOR_OFF, 0xFFFFFFFF);
            }
            else{
                dome_active = 1;
                dome_out = 0;
                dome_W.Draw(0xFFFFFFFF, 0xFF000000);
            }
        }  
        if (rasant_R.Touched()){
            if(rasant_active){
                rasant_active = 0;
                rasant_out = 1;
                all_on_active = 0;
                rasant_R.Draw(COLOR_OFF);
            }
            else{
                rasant_active = 1;
                rasant_out = 0;
                rasant_R.Draw(0xFFFF0000);
            }
        }     
        if (flex1_W.Touched()){
            if(flex1_active){
                flex1_active = 0;
                flex1_out = 1;
                all_on_active = 0;
                flex1_W.Draw(COLOR_OFF, 0xFFFFFFFF);
            }
            else{
                flex1_active = 1;
                flex1_out = 0;
                flex1_W.Draw(0xFFEEEEEE, 0xFF000000);
            }
        }   
        
        if (flex2_W.Touched()){
            if(flex2_active){
                flex2_active = 0;
                flex2_out = 1;
                all_on_active = 0;
                flex2_W.Draw(COLOR_OFF, 0xFFFFFFFF);
            }
            else{
                flex2_active = 1;
                flex2_out = 0;
                flex2_W.Draw(0xFFEEEEEE, 0xFF000000);
            }
        } 
    }  
    if (conv_speed.Slide())
    {
        int8_t x = (int8_t)conv_speed.GetValue();
        conv_speed_lab.Draw("%3d", x);          
    }

} 

/* updateIHM */
void moveConveyor(char dir, int speed_us){
    conveyor_enable = 0;
    conveyor_speed.period_us(speed_us);
    conveyor_dir = dir;
    conveyor_speed.write(0.5);      
}
/* updateIHM */
void stopConveyor(void){
    conveyor_enable = 1;
    conveyor_speed.write(0);      
}
