#include "mbed.h"

#define     ETAT_STOP           0
#define     ETAT_WAIT_PARAM     1
#define     ETAT_WAIT_PARAM_N   11
#define     ETAT_WAIT_PARAM_F   12
#define     ETAT_WAIT_PARAM_S   13
#define     ETAT_WAIT_GO        2
#define     ETAT_ACQUIRING      3
#define     ETAT_SENDING_DATA   4

// inputs and outputs configuration
DigitalOut  debug_led(LED1);
Serial      rs232(USBTX, USBRX);
AnalogIn    can_input(A0);
InterruptIn sync_input(D10);

Ticker tictoc;
Ticker blinky;

// System functions
void ISR_sync(void);
void convert_signal(void);
void ISR_get_data(void);
void ISR_send_data(void);
void TIK_blink_led(void);

// System variables
int i, pdix, temp;
char etat = 0;
char data_received, i_received;
char tab_received[10] = {0};

// Acquisition parameters
int     number_points;
int     frequency;
char    sync = 0;

// Acquisition data
int     i_data;
int     tab_data[10000];

// Main function
int main() {
    number_points = 0;
    frequency = 0;
    i_received = 0;
    etat = ETAT_STOP;
    data_received = '0';
    debug_led = 0;
    i_data = 0;
    rs232.baud(115200);
    rs232.attach(&ISR_get_data);
    sync_input.rise(&ISR_sync);
    while(1) {
        switch(etat){

            case ETAT_SENDING_DATA :
                rs232.putc('d');
                blinky.detach();
                tictoc.detach();
                debug_led = 1;
                for(i = 0; i < number_points; i++){
                    rs232.printf("[%d;%d]", i, tab_data[i]);
                }
                etat = ETAT_STOP;
                debug_led = 0;
                break;
            default :
                temp = 0;
        }
    }
}

void ISR_sync(void){
    if((etat == ETAT_ACQUIRING) && (sync == 1)){
        float period = 1.0/frequency;
        tictoc.attach(&convert_signal,period);
    }
} 

void convert_signal(void){
    tab_data[i_data] = can_input.read_u16() >> 4;
    i_data++;
    if(i_data == number_points){
        etat = ETAT_SENDING_DATA;
        tictoc.detach();
    }
}

void ISR_send_data(){
    i++;
    rs232.printf("i=%d:\r\n", i);
}

void ISR_get_data(){
    data_received = rs232.getc();
    if((data_received == 'U') && (etat != ETAT_STOP) && (etat != ETAT_ACQUIRING) && (etat != ETAT_SENDING_DATA)){   // UPDATE parameters
        rs232.putc('u');
        etat = ETAT_WAIT_PARAM;
        blinky.attach(&TIK_blink_led, 0.5);
    }
    
    switch(etat){
        case ETAT_STOP :
            if(data_received == 'a'){
                etat = ETAT_WAIT_PARAM;
                rs232.putc('o');
                blinky.attach(&TIK_blink_led, 0.5);
            }            
            break;
        case ETAT_WAIT_PARAM :
            if(data_received == 'n'){
                rs232.putc('n');
                etat = ETAT_WAIT_PARAM_N;
                i_received = 0;
            }
            break;    
        case ETAT_WAIT_PARAM_N :
            if(data_received == 'f'){
                rs232.putc('f');
                // param number of points
                number_points = 0;
                pdix = 1;
                for(i = i_received-1; i >= 0; i--){
                    number_points += (tab_received[i] - '0') * pdix;
                    pdix = pdix * 10;
                }
                // next state
                etat = ETAT_WAIT_PARAM_F;
                i_received = 0;
            }
            else{
                tab_received[i_received] = data_received;
                i_received++;
            }
            break;    
        case ETAT_WAIT_PARAM_F :
            if(data_received == 's'){
                rs232.putc('s');
                // param frequency
                frequency = 0;
                pdix = 1;
                for(i = i_received-1; i >= 0; i--){
                    frequency += (tab_received[i] - '0') * pdix;
                    pdix = pdix * 10;
                }
                // next state
                etat = ETAT_WAIT_PARAM_S;
                i_received = 0;
            }
            else{
                tab_received[i_received] = data_received;
                i_received++;
            }
            break; 
        case ETAT_WAIT_PARAM_S :
            // param synchro
            sync = data_received - '0';
            // next state
            etat = ETAT_WAIT_GO;
            i_received = 0;
            rs232.printf("N=%d;F=%d;S=%d;",number_points, frequency, sync);
            break; 
        case ETAT_WAIT_GO :
            if(data_received == 'G'){
                etat = ETAT_ACQUIRING;
                blinky.detach();
                blinky.attach(&TIK_blink_led, 0.1);
                if(sync == 0){
                    float period = 1.0/frequency;
                    tictoc.attach(&convert_signal,period);
                }   
            }
            break;
        default :
            etat = ETAT_STOP;
            debug_led = 0;
    }
}

void TIK_blink_led(void){
    debug_led = !debug_led;
}