#include "mbed.h"
#include "time.h"
#include "F429_GUI.hpp"
#include "IOGS_LEnsE_GUI.hpp"

#define TE          0.00003

LCD_DISCO_F429ZI lcd;
TS_DISCO_F429ZI ts;

Serial pc(USBTX, USBRX);
DigitalIn my_bp(USER_BUTTON);
DigitalOut sortie_test(PF_12);      // Sortie de test pour mesurer le temps de calcul de la conversion
/* Conversion Analog / Num - Num / Analog */
AnalogIn son_entree(PC_1);
AnalogOut son_sortie(PA_5); // ATTENTION NE PAS MODIFIER LES E/S
float in, out;

/* Timer a repetition */
Ticker tik;

/* Conversion à intervalle régulier grace au Ticker */
void convert(void){
    sortie_test = 1;
    in = son_entree.read();    // Lecture de l'entree analogique
    out = in;              // Calcul de la sortie
    son_sortie.write(out); // Ecriture de la sortie analogique
    sortie_test = 0;
}

/* Fonction principale */
int main()
{
    int val;
    pc.baud(115200);
    
    wait(1.0);
    pc.printf("WDM Demo\r\n");
        
    int x_MAX, y_MAX;
    x_MAX = lcd.GetXSize();
    y_MAX = lcd.GetYSize();
    pc.printf("xMax = %d / yMax = %d \r\n", x_MAX, y_MAX);
    
    Label label1(x_MAX/2, y_MAX/2, "GUI Test", Label::CENTER, Font16, LCD_COLOR_WHITE, LCD_COLOR_BLUE);
    NumericLabel<int> my_value(10, 100, "", Label::LEFT, Font12, LCD_COLOR_MAGENTA);
    
    // Affichage Fenetre graphique avec logo
    DrawImage(my_logo, &lcd);
    wait(5);
    lcd.Clear(LCD_COLOR_LIGHTGRAY);
    
    // Fonction de conversion à intervalle régulier
    tik.attach(&convert, TE);

    while (true)
    {
        pc.scanf("%d", &val);
        pc.printf("Test = %d \r\n", val);
        my_value.Draw("%3d", val);
    }
}
