/****************************************************************************/
/*  Test MOD-24LR / nrf24L01                                                */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Brochage                                                                */
/*      TO COMPLETE                                                         */
/****************************************************************************/
/*  Test réalisé sur Nucléo-F411RE                                          */
/****************************************************************************/

#include "mbed.h"
#include "MOD24_NRF.h"
#define TRANSFER_SIZE   4

nRF24L01P       my_mod(D11, D12, D13, D7, D8, D5);

Serial          pc(USBTX, USBRX);
DigitalIn       my_bp(USER_BUTTON);

char k;
char    dataToSend[TRANSFER_SIZE] = {0xAA, 0x01, 0x10, 0xF0};
char    dataReceived[TRANSFER_SIZE] = {0};

int main() {
    pc.printf("Test\r\n");
    my_mod.setRfFrequency(2400);
    wait(0.1);
    my_mod.powerUp();
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_mod.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_mod.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_mod.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_mod.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_mod.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_mod.setTransferSize( TRANSFER_SIZE );

    my_mod.setReceiveMode();
    my_mod.enable();
    
    while(1) {
        if(my_bp == 1){
            my_mod.setRfFrequency(2400);
        }
        else{
            my_mod.setRfFrequency(2500);
        }
        my_mod.write( NRF24L01P_PIPE_P0, dataToSend, TRANSFER_SIZE );
        pc.printf( "SENDED\r\n");
        wait(1);        
    }
}
