/****************************************************************************/
/*  Test MOD-24LR / nrf24L01                                                */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Brochage                                                                */
/*      TO COMPLETE                                                         */
/****************************************************************************/
/*  Test réalisé sur Nucléo-F411RE                                          */
/****************************************************************************/

#include "mbed.h"
#include "MOD24_NRF.h"
#define TRANSFER_SIZE   8

nRF24L01P       my_mod(PC_12, PC_11, PC_10, PH_1, PH_0, PD_2);
// MOSI, MISO, SCK, CSN, CE, IRQ

Serial          pc(USBTX, USBRX);
DigitalIn       my_bp(USER_BUTTON);

char k;
char    dataToSend[TRANSFER_SIZE] = {0xAA, 0x01, 0x10, 0xF0,0xAA, 0x01, 0x10, 0xF0};
char    dataReceived[TRANSFER_SIZE] = {0};
char    rxDataCnt;

int main() {
    pc.printf("Test\r\n");
    my_mod.setRfFrequency(2400);
    wait_ms(100);
    my_mod.powerUp();
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_mod.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_mod.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_mod.getAirDataRate() );

    pc.printf( "Transfers are grouped into %d characters\r\n", TRANSFER_SIZE );

    my_mod.setTransferSize( TRANSFER_SIZE );

    my_mod.setReceiveMode();
    my_mod.enable();
    
    while(1) {
        if ( my_mod.readable() ) {

            // ...read the data into the receive buffer
            rxDataCnt = my_mod.read( NRF24L01P_PIPE_P0, dataReceived, TRANSFER_SIZE);

            // Display the receive buffer contents via the host serial link
            pc.printf("\tD = ");
            for ( int i = 0; i < rxDataCnt; i++ ) {
                pc.printf(" %x \t", dataReceived[i]);
            }
            pc.printf("\r\n");
        }   
        if(my_bp == 0){
            my_mod.setRfFrequency(2400);
            my_mod.write( NRF24L01P_PIPE_P0, dataToSend, TRANSFER_SIZE );
            pc.printf( "SENDED\r\n");
            wait_ms(100);
        }         
    }
}
