/****************************************************************************/
/*  FFT d'un signal   - Nucleo                                              */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Brochage                                                                */
/*      TO COMPLETE                                                         */
/****************************************************************************/
/*  Test réalisé sur Nucléo-L476RG                                          */
/****************************************************************************/

#include "mbed.h"
#include "arm_math.h"
/* Include mbed-dsp libraries */
#include "dsp.h"
#include "arm_common_tables.h"
#include "arm_const_structs.h"

#define SAMPLES                 512             /* 256 real party and 256 imaginary parts */
#define FFT_SIZE                SAMPLES / 2     /* FFT size is always the same size as we have samples, so 256 in our case */
 
float32_t Input[SAMPLES];
float32_t Output[FFT_SIZE];
bool      trig=0;
int       indice = 0;

DigitalOut myled(LED1);
AnalogIn   myADC(A0);
AnalogOut  myDAC(A2);
Serial     pc(USBTX, USBRX);
Ticker     timer;
 
void sample(){
    myled = 1;
    if(indice < SAMPLES){
        Input[indice] = myADC.read() - 0.5f;    //Real part NB removing DC offset
        Input[indice + 1] = 0;                  //Imaginary Part set to zero
        indice += 2;
    }
    else{ trig = 0; }
    myled = 0;
}
 
int main() {
    float maxValue;            // Max FFT value is stored here
    uint32_t maxIndex;         // Index in Output array where max value is

    while(1) {
        if(trig == 0){
            timer.detach();
            // Init the Complex FFT module, intFlag = 0, doBitReverse = 1
            //NB using predefined arm_cfft_sR_f32_lenXXX, in this case XXX is 256
            arm_cfft_f32(&arm_cfft_sR_f32_len256, Input, 0, 1);
 
            // Complex Magniture Module put results into Output(Half size of the Input)
            arm_cmplx_mag_f32(Input, Output, FFT_SIZE);
            Output[0] = 0;
            //Calculates maxValue and returns corresponding value
            arm_max_f32(Output, FFT_SIZE/2, &maxValue, &maxIndex);
        
            myDAC=1.0;     //SYNC Pulse to DAC Output
            wait_us(20);    //Used on Oscilliscope set trigger level to the highest
            myDAC=0.0;     //point on this pulse 
    
            for(int i=0; i < FFT_SIZE / 2; i++){
                myDAC=(Output[i]) * 0.9;   // Scale to Max Value and scale to 90 / 100
                wait_us(10);                //Each pulse of 10us is 50KHz/256 = 195Hz resolution
            }
            myDAC=0.0;
            pc.printf("MAX = %lf, %d \r\n", maxValue, maxIndex);
            wait(0.2);
            trig = 1;
            indice = 0;
            timer.attach_us(&sample,40);      //20us 50KHz sampling rate
        }
    }
}