#include "lcd.h"

EADogLcd::EADogLcd(PinName RS_LCD,PinName SCK,PinName MOSI,PinName CS) : spi(D11,D12,D13), CS(D10), RS_LCD(D9){
    init_SPI();
}
    
void EADogLcd::init_SPI(void){
    // Chip must be deselected
    CS = 1;
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(10000); 
    // Select the device by seting chip select low
    }
    
void EADogLcd::init_LCD(void){
    init_SPI();
    wait_ms(10);
    CS = 0;
    RS_LCD = 0;
    spi.write(0x29); // Function Set - Table 1
    spi.write(0x1D); // Bias Set
    spi.write(0x50); // Power Control
    spi.write(0x6C); // Follower Control
    spi.write(0x7C); // Contrast Set
    spi.write(0x03); // Function Set - Table 0
    spi.write(0x0F); 
    spi.write(0x01); // Clear Display
    wait_ms(2);
    spi.write(0x06); // Display On
    wait_ms(10);
    RS_LCD=1;
    CS=1;
    wait_ms(10);
    return;
    } 
    
void EADogLcd::writeCmd_LCD(char c){
    CS =0;
    RS_LCD =0;
    spi.write(c);
    RS_LCD = 1;
    CS = 1;
    return;
}
void EADogLcd::setPosition(char ligne, char colonne){
    char adress = 0x80 + ((ligne-1)*16) + (colonne -1);
    writeCmd_LCD(adress);
    wait_ms(1);
    return;
}
void EADogLcd::writeStr_LCD(char c[], char ligne, char colonne){
    char i=0;
    setPosition(ligne,colonne);
    while(c[i] != '\0'){
        write_LCD(c[i]);
        i++;        
    }
    char lig = i/16 + 1;
    char col = i%16 + 1;
    setPosition(lig,col);
}
void EADogLcd::write_LCD(char c){
    CS = 0;
    RS_LCD = 1;
    spi.write(c);
  //  wait_ms(1);
    RS_LCD = 1;
    CS = 1;
    return;
    }
    