#include "mbed.h"
#include "mlx90614.h"
#include "rpc.h"
#include "adc.h"
#include "SerialRPCInterface.h"

#define SAMPLE_RATE    150000


ADC adc(SAMPLE_RATE, 1);
// the default address of the infrared sensor (7 bit address + 1 bit for read/write, 0xB4 for write)
char i2caddress = 0xB4; 

AnalogIn ain(p20); //adc from pin 20
DigitalOut myled(LED1); //displays I2C wait
I2C i2c(p28,p27);   //sda,scl
SerialRPCInterface RPC(USBTX, USBRX); 

bool getTemp(float* temp_val){

    char p1,p2,p3;
    float temp_thermo;
    bool ch;

    i2c.stop();                            //stop i2c if not ack
    wait(0.01);
    i2c.start();                           //start I2C                   
    ch=i2c.write(i2caddress);              //device address with write condition
    
    if(!ch){
        return false;
    }                                        //No Ack, return False
    
    ch=i2c.write(0x07);                    //device ram address where Tobj value is present

    if(!ch){
        return false;
    }

    i2c.start();                           //repeat start
    ch=i2c.write(i2caddress|0x01);         //device address with read condition 
    if(!ch){
        return false;
    }

    p1=i2c.read(1);     //Tobj low byte
    p2=i2c.read(1);     //Tobj heigh byte
    p3=i2c.read(0);     //PEC
    
    i2c.stop();                            //stop condition
     
    
    temp_thermo=((((p2&0x007f)<<8)+p1)*0.02)-0.01;      //degree centigrate conversion
    *temp_val=temp_thermo-273;                          //Convert kelvin to degree Celsius
    
    return true;                            //load data successfully, return true 
}


float IRTemp = 0; //temperature in degrees C
float AnalogTemp;
float IRTempTemp;

void anaali(char* input, char* output);
void digit(char* input, char* output);

RPCFunction rpc_anal(&anaali, "rpc_anal");
RPCFunction rpc_digi(&digit, "rpc_digi");

           
int main() {

    wait(1);
    while (1) {
        myled=1;
        if (getTemp(&IRTempTemp)) {
            myled=0;
        }
        wait(0.5);
        if(IRTempTemp < 150) //discard clearly wrong values from trying to read the sensor when it's not ready
            IRTemp = IRTempTemp;
    }
}

void anaali(char* input, char* output){ 
    sprintf(output, "%f", (float)ain); //prints the analog sensor value to the output stream
}

void digit(char* input, char* output){
    sprintf(output, "%f", IRTemp); //prints the digital sensor value to the output stream
}