#include "mbed.h"
#include "ble/BLE.h"

#include "PowerSwitch.h"
#include "Light.h"

#include "ServicePower.h"
#include "FlashStore.h"

BLE ble;
PowerSwitch power(p30);
Light light(p6);

Serial serial(USBTX, USBRX); // tx, rx
FlashStore store(serial);
                                      
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *){
    ble.startAdvertising();
    serial.printf("BLE Disconnected!\r\n");
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params)
{
    serial.printf("BLE Connected!\r\n");
    
}


int main(void){
    
    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().onConnection(connectionCallback);

    //ServiceDeviceInformation deviceService(ble, "Seed", "AEAB00", "AEAB00-010000001", NULL, "1.0.0-alfa", NULL);
    ServicePower    powerService(ble, serial, power, light, store);  
    

    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"POWER SWITCH", sizeof("POWER SWITCH") - 1);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)Power_service_UUID, sizeof(Power_service_UUID));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);    
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);

    ble.gap().setAdvertisingInterval(1000); 
    ble.gap().startAdvertising();          
    
    while (true) {
        ble.waitForEvent(); 
    }
}