#ifndef __BLE_SERVICE_POWER_H__
#define __BLE_SERVICE_POWER_H__

#include "BLE.h"
#include "PowerSwitch.h"
#include "Light.h"
#include "FlashStore.h"

extern const uint8_t Power_service_UUID[UUID::LENGTH_OF_LONG_UUID];
extern const uint8_t Power_value_char_UUID[UUID::LENGTH_OF_LONG_UUID];
extern const uint8_t Power_state_char_UUID[UUID::LENGTH_OF_LONG_UUID];

class ServicePower {
   
public:
    ServicePower(BLE &_ble, Serial &_Serial, PowerSwitch &_Power, Light &_dayLight, FlashStore &_Store) :
        ble(_ble),
        Tserial(_Serial),
        Power(_Power),
        dayLight(_dayLight),
        Store(_Store),        
        valueCharacteristic(Power_value_char_UUID, &powerValue, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        stateCharacteristic(Power_state_char_UUID, &powerState)
    {
        setupService();
    }
    
    
    virtual void onDataWritten(const GattWriteCallbackParams *params) {
        if (params->handle == stateCharacteristic.getValueAttribute().getHandle() && (params->len == sizeof(powerState))) {           
            powerState = *(params->data);    
            
            powerState ? Power.doSwitch(true,2.0) : Power.doSwitch(false, 2.0);
            Tserial.printf("Power: %s\n", powerState ? "on" : "off");    
                            
        }        
    }

protected:
    void setupService(void) {
        GattCharacteristic *characteristics[] = {&stateCharacteristic, &valueCharacteristic};
        GattService powerService(Power_service_UUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));

        powerState = false;
        powerValue = 0.0;

        ble.addService(powerService);
        ble.onDataWritten(this, &ServicePower::onDataWritten);
        
        updatePowerValue();
        measurePeriod.attach(this, &ServicePower::updatePowerValue, 1.0);

              
    }
    
     void updatePowerValue(void) {
        
        powerValue = dayLight.getLightValue();        
        ble.updateCharacteristicValue(valueCharacteristic.getValueAttribute().getHandle(), (uint8_t *)&powerValue, sizeof(powerValue));                
        Tserial.printf("updatePowerValue: %f \n", powerValue);
    
    }
    

protected:
    BLE    &ble;
    PowerSwitch &Power;
    Light &dayLight;
    FlashStore &Store;
    
    Ticker measurePeriod;
    
    bool  powerState;
    float  powerValue;    
    
    ReadWriteGattCharacteristic<bool> stateCharacteristic;
    ReadOnlyGattCharacteristic<float> valueCharacteristic;
    
    Serial &Tserial; // tx, rx

};

#endif /* #ifndef __BLE_SERVICE_POWER_H__*/