#include "PowerSwitch.h"
#include "mbed.h"
 
PowerSwitch::PowerSwitch(PinName pin)  : _pin(pin)  {
    powerState = false;
}
 
void PowerSwitch::doSwitch(bool state, float duration){
        if (state) {
            _pin = 1.0;       
        } else{
            _pin = 0.0;     
        }
        
        powerState = state;
        switchPeriod.attach(this, &PowerSwitch::doSwitchEnd, duration);

}  

bool PowerSwitch::powerStateOn(void){
       return powerState;        
}   

void PowerSwitch::doSwitchEnd(void){       
   switchPeriod.detach();
   _pin = 0.0;   
}