#ifndef MBED_FLASHSTORE_H
#define MBED_FLASHSTORE_H
 
#include "mbed.h"

#include "pstorage.h"
#include "nrf_error.h"

struct settings {
    char devicever[10];
    char devicepin[4];
    char devicename[20];
    int deviceblemajor;
    int devicebleminor;
    int devicepower;
};

struct measure {
  long madatetime;
  float measurevaue;
};



class FlashStore {
public:
    
    FlashStore(Serial &_Serial) : Tserial(_Serial)        
    {
        storestate = 0;
        void setupStore(void);
    }       
    
    void saveSettings(char name[20], char pin[4], int power, int bleMinor, int bleMajor, char version[10]) {
                
        settings toSave;
                
      //  toSave.devicename = name;
      //  toSave.devicepin = pin;
        toSave.devicepower = power;
        toSave.devicebleminor = bleMinor;
        toSave.deviceblemajor = bleMajor;
      //  toSave.devicever = version;
        
        tempstate = pstorage_store(&settingsHandle, (uint8_t *)&toSave, sizeof(toSave), 0);
        Tserial.printf("FlashStore saveSettings\r\n");
        
        if (tempstate == NRF_SUCCESS) {
            Tserial.printf("FlashStore saveSettings - ok! \r\n");
        }
        
    }
    
     void readSettings(void) {
        
        settings toLoad;
        
        tempstate = pstorage_load((uint8_t *)&toLoad, &settingsHandle, sizeof(toLoad), 0);
        Tserial.printf("FlashStore readSettings\r\n");
        if (tempstate == NRF_SUCCESS) {
        
            Tserial.printf("FlashStore readSettings - ok: %s\r\n", toLoad.devicename );     
             
        }
        
        
        
        Tserial.printf("FlashStore Read It\r\n");
    }



    
private:  
   Serial &Tserial; // tx, rx
   uint32_t storestate; // 0 - not init, 1 - not register, 2 - not measure register, 3 - ok
   uint32_t tempstate;
   pstorage_handle_t settingsHandle, measureHandle;
   pstorage_module_param_t settingsParams, measureParams;
   
    void setupStore(void) {
        tempstate = pstorage_init(); 
        
        if(tempstate == NRF_SUCCESS) {
            
            storestate = 1;                    
            
            settingsParams.block_size  = sizeof(settings);
            settingsParams.block_count = 1; 
            settingsParams.cb = cb_handler;            
            tempstate = pstorage_register(&settingsParams, &settingsHandle);
            
            if (tempstate == NRF_SUCCESS)
            {
                storestate = 2;                                                
            }                           
        }
        
        Tserial.printf("FlashStore up\r\n");
    }
   
   
    static void cb_handler(pstorage_handle_t  * handle,
                               uint8_t              op_code,
                               uint32_t             result,
                               uint8_t            * p_data,
                               uint32_t             data_len)
    {
        //Tserial.printf("Callback handler successful\r\n");
    }
    
   
    
};
 
#endif