/*******************************************************************************
################################################################################
#                             (C) STMicroelectronics 2014
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License version 2 and only version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#------------------------------------------------------------------------------
#                             Imaging Division
################################################################################
********************************************************************************/

#include "definitions.h"
#include "platform.h"
#include "debug.h"
#include "i2c_log.h"
#ifndef __KERNEL__
#include "i2c_stm32_mbed.h"
#include "timer_stm32_mbed.h"
#else
#include <linux/i2c.h>
#define I2C_M_WR			0x00
#endif
static char time_str[255];

void debug1_print(char* pBuffer)
{
    //output to UART
    serial_printf(pBuffer);
}

void debug2_print(char* pBuffer)
{
    //output to UART
    serial_printf(pBuffer);
}

void i2c_initialise(uint32_t addr)
{
    stm32_i2c_initialise(addr);
}

void i2c_close()
{
    stm32_i2c_close();
}

void i2c_write_byte(uint32_t reg, uint8_t data, uint8_t baseAddr)
{
    stm32_i2c_write_byte(reg, data, baseAddr);
    i2c_log_outputWriteByteMsg(data, reg);
}


void i2c_write_word(uint32_t reg, uint16_t data, uint8_t baseAddr)
{
    stm32_i2c_write_word(reg, data, baseAddr);
    i2c_log_outputWriteWordMsg(data, reg);
}

void i2c_write(uint32_t reg, uint8_t *data, int32_t size, uint8_t baseAddr)
{
    stm32_i2c_write(reg, data, size, baseAddr);
    i2c_log_outputWriteMsg(data, reg, size);
}

uint8_t i2c_read_byte(uint32_t reg, uint8_t baseAddr)
{
    uint8_t data = stm32_i2c_read_byte(reg, baseAddr);
    i2c_log_outputReadByteMsg(data, reg);
    return data;
}

uint16_t i2c_read_word(uint32_t reg, uint8_t baseAddr)
{
    uint16_t data = stm32_i2c_read_word(reg, baseAddr);
    i2c_log_outputReadWordMsg(data, reg);
    return data;
}

uint32_t i2c_read_uint32(uint32_t reg, uint8_t baseAddr)
{
    uint32_t data = stm32_i2c_read_int(reg, baseAddr);
    i2c_log_outputReadIntMsg(data, reg);
    return data;
}

void i2c_read(uint32_t reg, uint8_t *dataOut, int32_t size, uint8_t baseAddr)
{
    stm32_i2c_read(reg, dataOut, size, baseAddr);
    i2c_log_outputReadMsg(dataOut, reg, size);
}

void timer_start()
{
    stm32_timer_start();
}

double_t timer_elapsedTime()
{
    return stm32_timer_elapsed_time();
}

void timer_stop()
{
    stm32_timer_stop();
}

void timer_wait_ms(int32_t ms)
{
    stm32_timer_wait_ms((int)ms);
}

void timer_wait_us(int32_t us)
{
    stm32_timer_wait_us((int)us);
}

uint32_t timer_get_clock_time_usecs()
{
    return stm32_timer_get_clock_time_usecs();
}

uint32_t timer_get_clock_time_msecs()
{
    return stm32_timer_get_clock_time_msecs();
}

char* timer_get_clock_timestamp()
{
    stm32_timer_get_clock_timestamp(time_str);
    return time_str;
}

